// pages/addapproval/addapproval.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    addapprovaliconImgUrl: 'http://39.102.232.151:8030/cover/添加证书icon.png',
    approvalName: '',
    uploadDate: '01:01:00',
    validDate: '2021-09-09',
    certifyFile: null,
    fileName: '请选择要上传内容',
    compnayId: '',
    isShowImg: false,
    showImgSrc: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options, 'addapproval options')
    this.data.companyId = options.companyId
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '新增危险备案'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  inputApprovalName(event) {
    console.log(event, 'event event event')
    this.data.approvalName = event.detail.value
  },
  inputJobTime(event) {
    console.log(event, 'inputJobName inputJobName')
    // this.data.validDate = event.detail.value
    this.setData({
      validDate: event.detail.value
    })
  },
  inputUploadDate(event) {
    console.log(event, 'inputUploadDate inputUploadDate')
    // this.data.uploadDate = event.detail.value
    this.setData({
      uploadDate: event.detail.value + ":00"
    })
  },
  chooseJobFile(event) {
    console.log(event, 'chooseJobFile chooseJobFile')
    wx.chooseMessageFile({
      count: 1,
      success: (res) => {
        console.log(res, 'chhofhasdhf s')
        this.data.certifyFile= res.tempFiles[0].path
        this.setData({
          fileName: res.tempFiles[0].name
        })
      }
    })
  },
  uploadApprovalFile() {
    if (!this.data.approvalName) {
      wx.showToast({
        title: '请输入备案名称',
      })
      return
    }
    if (!this.data.validDate) {
      wx.showToast({
        title: '请输入作业时间',
      })
      return
    }
    if (!this.data.uploadDate) {
      wx.showToast({
        title: '请输入上传时间',
      })
      return
    }
    if (!this.data.certifyFile) {
      wx.showToast({
        title: '请选择上传文件',
      })
      return
    }

    let formObj = {
      name: this.data.approvalName,
      time: this.data.validDate + ' ' +this.data.uploadDate,
      companyId: this.data.companyId
    }
    console.log(formObj, 'this.formObj')
    wx.uploadFile({
      filePath: this.data.certifyFile,
      name: 'file',
      header: {
        Authorization: app.globalData.Authorization
      },
      url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport',
      formData: formObj,
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res, )
        wx.navigateBack()
        wx.showToast({
          title: '上传成功',
        })
      }
    })
  }
})