const app = getApp()
// pages/dangerlist/dangerlist.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    msgShow:false,
    dglist: [],
    curEnterName: '',
    leftMove: {},
    topAnimation: {},
    curRole: ''
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      curRole: app.globalData.curRole
    })
    const animation = wx.createAnimation({
      delay: 20,
      timingFunction: 'linear'
    })
    this.animation = animation
    this.setData({
      curEnterName: app.globalData.currentEnter.companyName
    })
    // console.log('dgonload')
    wx.showLoading({
      title: '正在加载隐患列表',
    })
    wx.request({
      url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
      method: 'GET',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        county:app.globalData.appCounty,
        companyId: app.globalData.currentEnter.companyId,
        sort: 'hdId,asc',
        page: 0,
        size: 99999
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        let arr=  [...res.data.content]
        let newarr = [];
        arr.map((item,index)=>{
          newarr.push(Object.assign(item,{msgShow:false}))
        })
        arr = newarr;
        console.log(arr, '获取当前企业的隐患arr3')
        if (res.statusCode === 200) {
          this.setData({
            dglist: [...res.data.content]
          })
          return;
        } else if (res.statusCode === 401) {
          wx.redirectTo({
            url: '/pages/login/login',
          })
        } else {
          wx.showToast({
            title: '获取失败',
            icon: 'error',
            duration: 2000
          })
        }
        wx.hideLoading()
      },
      fail: () => {
        wx.hideLoading()
      }
    })
    console.log(this.data.curRole,'sssssssssss-----------------------')
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    // console.log('dgonready')
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    // console.log('dgonshow')
    wx.setNavigationBarTitle({
      title: app.globalData.currentEnter.companyName,
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff'
    })
    wx.showLoading({
      title: '正在加载隐患列表',
    })
    wx.request({
      url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
      method: 'GET',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        county:app.globalData.appCounty,
        companyId: app.globalData.currentEnter.companyId,
        sort: 'hdId,asc',
        page: 0,
        size: 99999
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        
        let arr=  [...res.data.content]
        let newarr = [];
        arr.map((item,index)=>{
          newarr.push(Object.assign(item,{msgShow:false}))
        })
        arr = newarr;
        console.log(arr, '获取当前企业的隐患arr2')
        if (res.statusCode === 200) {
          this.setData({
            dglist: [...res.data.content]
          })
        } else if (res.statusCode === 401) {
          wx.redirectTo({
            url: '/pages/login/login',
          })
        } else {
          wx.showToast({
            title: '获取失败',
            icon: 'error',
            duration: 2000
          })
        }
        wx.hideLoading()
      },
      fail: () => {
        wx.hideLoading()
      }
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {
    // console.log('dgonhide')
  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {
    // console.log('dgonupload')
  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    // console.log('dgonpulldown')
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    // console.log('dgonreachBottom')
  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {
    // console.log('dgonshareappmessage')
  },
  // 查询未通过原因
  checkReason(e){
    wx.request({
      url: app.globalData.appBaseUrl + '/api/hiddenDangerToVerify',
      method: 'GET',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        enName:this.data.curEnterName,
        hd_id:e.currentTarget.dataset.word.hdId,
        page: 0,
        size: 99999
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        if (res.statusCode === 200) {
        console.log(res.data.content,'...')
          let list = res.data.content
          let newMsgArr=[]
          for(let i=0;i<list.length;i++){
            if(e.currentTarget.dataset.word.hdId===list[i].hdId){
              newMsgArr.push(list[i])
            }
          }
          let compare = function (obj1, obj2) {
            var val1 = obj1.id;
            var val2 = obj2.id;
            if (val1 < val2) {
                return -1;
            } else if (val1 > val2) {
                return 1;
            } else {
                return 0;
            }            
        } 
        console.log(newMsgArr)
        let sortMsg=newMsgArr.sort(compare)
        let len=sortMsg.length
        let newMsg = sortMsg[len-1].refuseReason
        console.log(newMsg)
        this.setData({
          newMsg: newMsg,
          // msgShow:!this.data.msgShow
        })
        wx.showModal({
          title: '未通过原因',
          content: this.data.newMsg,
          success: function (res) {
              if (res.confirm) {
                  console.log('用户点击确定')
              }else{
              console.log('用户点击取消')
              }

          }
      })
        } else if (res.statusCode === 401) {
          wx.redirectTo({
            url: '/pages/login/login',
          })
        } else {
          wx.showToast({
            title: '获取失败',
            icon: 'error',
            duration: 2000
          })
        }
        wx.hideLoading()
      },
      fail: () => {
        wx.hideLoading()
      }
    })
  },
  /**
   * 新增隐患
   */

  addNewHD(event) {
    console.log(event, 'hehe')
    wx.navigateTo({
      url: '/pages/dangerregister/dangerregister',
    })
  },
  /**
   * 编辑隐患
   */
  editHD(event) {
    console.log(event.target.dataset.index)
    // event.target.dateset.index
    app.globalData.currentHD = {...this.data.dglist[event.target.dataset.index]}
    // console.log(app.globalData.currentHD)
    wx.navigateTo({
      url: '/pages/dangeredit/dangeredit',
    })
    // this.animation.translateX('50rpx').step()
    // this.setData({
    //   leftMove: this.animation.export()
    // })
  },

  cancelToDelete() {
    this.animation.bottom('-100%').step()
    this.setData({
      topAnimation: this.animation.export()
    })
  },
  confirmToDelete() {
    wx.showLoading({
      title: '正在删除',
    })
    wx.request({
      url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
      method: 'DELETE',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: [this.data.dglist[this.deleteIndex].hdId],
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        // console.log(res, 'hehehheeheh')
        if (res.statusCode === 200) {
          wx.showToast({
            title: '删除成功',
            icon: 'success'
          })
          this.animation.bottom('-100%').step()
          this.setData({
            topAnimation: this.animation.export()
          })
          wx.showLoading({
            title: '正在加载隐患列表',
          })
          wx.request({
            url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
            method: 'GET',
            header: {
              Authorization: app.globalData.Authorization
            },
            data: {
              county:app.globalData.appCounty,
              companyId: app.globalData.currentEnter.companyId,
              sort: 'hdId,asc',
              page: 0,
              size: 99999
            },
            header: {
              Authorization: app.globalData.Authorization
            },
            success: (res) => {
              let arr=  [...res.data.content]
              let newarr = [];
              arr.map((item,index)=>{
                newarr.push(Object.assign(item,{msgShow:false}))
              })
              arr = newarr;
              console.log(arr, '获取当前企业的隐患arr')
              if (res.statusCode === 200) {
                this.setData({
                  dglist: arr
                })
              } else if (res.statusCode === 401) {
                wx.redirectTo({
                  url: '/pages/login/login',
                })
              } else {
                wx.showToast({
                  title: '获取失败',
                  icon: 'error',
                  duration: 2000
                })
              }
              wx.hideLoading()
            },
            fail: () => {
              wx.hideLoading()
            }
          })
        } else if (res.statusCode === 401) {
          wx.redirectTo({
            url: '/pages/login/login',
          })
        } else {
          wx.showToast({
            title: '删除失败',
            icon: 'success'
          })
        }
      },
      fail: () => {
        wx.showToast({
          title: '删除失败',
        })
      },
      complete: () => {
        wx.hideLoading()
      }
    })
  },
  /**
   * 删除隐患
   */
  deleteHD(event) {
    console.log(event.target.dataset.index)
    this.deleteIndex = event.target.dataset.index

    this.animation.bottom(0).step()
    this.setData({
      topAnimation: this.animation.export()
    })

    // event.target.dateset.index
  },
  /**
   * 新增按钮开启
   */
  addBtnTouchStart(event) {
    const animation = wx.createAnimation({
      delay: 0,
      duration: 400,
      timingFunction: 'ease'
    })
    this.animation = animation
    animation.translateX('-20rpx').step()
    this.setData({
      leftMove: animation.export()
    })
    // setTimeout(() => {
    //   animation.translateX('50rpx').step()
    //   this.setData({
    //     leftMove: animation
    //   })
    // }, 400)
  },
  addBtnTouchEnd() {
    this.animation.translateX('0rpx').step()
    this.setData({
      leftMove: this.animation.export()
    })
  }
})