// pages/evaluate/evaluate.js
import * as echarts from '../ec-canvas/echarts'
const app = getApp();
function initChart(canvas, width, height, dpr) {
  const chart = echarts.init(canvas, null, {
    width: width,
    height: height,
    devicePixelRatio: dpr // new
  });
  canvas.setChart(chart);

  var option = {
    backgroundColor: "#ffffff",
    series: [{
      label: {
        normal: {
          fontSize: 14
        }
      },
      type: 'pie',
      center: ['50%', '50%'],
      radius: ['20%', '40%'],
      data: [{
        value: app.globalData.curEvaluate.lessThan60PeopleNum,
        name: '低于60分人数'
      }, {
        value: app.globalData.curEvaluate.between60And70PeopleNum,
        name: '60到70分之间的人数'
      }, {
        value: app.globalData.curEvaluate.between70And80PeopleNum,
        name: '70到80分之间的人数'
      }, {
        value: app.globalData.curEvaluate.between80And90PeopleNum,
        name: '80到90分之间的人数'
      }, {
        value: app.globalData.curEvaluate.moreThan90PeopleNum,
        name: '高于90分的人数'
      }]
    }]
  };

  chart.setOption(option);
  return chart;
}
/**
 * avgScore	integer($int32)
企业平均考试成绩


lessThan60PeopleNum	integer($int32)
低于60分人数

moreThan90PeopleNum	integer($int32)
高于90分的人数

between60And70PeopleNum	integer($int32)
60到70分之间的人数

between70And80PeopleNum	integer($int32)
70到80分之间的人数

between80And90PeopleNum	integer($int32)
80到90分之间的人数

courseCompletedLearnerNum	integer($int32)
完成全部课程人数

courseCompletedLearnerRate	string
完成全部课程比例（%）

courseLearnerNum	integer($int32)
参与学习人数

courseLearnerRate	string
学习比例（%）

courseStarLevel	integer($int32)
课程评价星级

examCompletedExamineeNum	integer($int32)
完成全部考试人数

examCompletedExamineeRate	string
完成全部考试比例（%）

examStarLevel	integer($int32)
考试评价星级

examineeNum	integer($int32)
参与考试人数

examineeRate	string
参与考试比例（%）


totalPeopleNum	integer($int32)
总人数
 */

Page({

  /**
   * 页面的初始数据
   */
  data: {
    grayStar: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAuhJREFUWEftlz1oFEEUx9/LWuhZWRmwEMRYeFh4++bYVJpGEWPjFwliIYKNgpUaMaIgBNTKj0YEEQsTNWChgrGKndmZ4YIBJUI8UqnVgZgi3m6eTLiDy3l7s9mRGMSBhWXnvff/8Z83c3MIq2zgKuOBfw9Ia70VAG4z8w9mHhBCfHZx3dkhrfVdZj5tIBDxge/7J/8a0MTExDbP86YbARYWFnYXi8W3WaGcHFJKDQHAxSbxZ0R0dMWBwjDs7Ojo+NJKmJl7hBDjWaAyO6S1vsLMVxOAXgsh9q0YkFIqBwBz7QSzupTJoXbuNECOE1HPcl1KBVQul9dWKpUtzLz4AMCtlEIDzDwDADNxHM8EQfDdlvcbkNa614giohGuA5j3dbZilvmImc2huQhoHgNbLBZfNOYtAZJS3kPEU47Cy01/SEQn6klLgJRSTwHgyHIrOsZrIqKWQFLKw4g4DABrHEXSpptl7BdCjLYEMh/DMDzged4wM69PWzVLHCLOxXHc37aH6oWVUnsAYAQANmQRS5FTAYA+InrTHJu47cMw3IWII4jYmUIgdQgzf2XmvqQf4LbnkNY6YGbj1ObUiu0DZxGxz/f9d0lh1oNRSrnTLB8ibnOBYuZPZpmEEKV2daxAJrnWU2MuQACwt1XPpO6hxkCllLnzmLtP5sHMF4QQN2wFUjmktR5l5kO2Ypb5x0R0zFYjFZCUctq1hxDxg+/7+T8CpJRiW6E080RkNcAaoJTaAQDv0wjaYqrV6vbu7u6PTrtMSnkcER9ZxK4hYpx0pa3n1s6gJ65A1xHxfKsizHwzl8sN5vP5n7XjIYeI55LAEHHI9/1LTkBKqZcAsL+pyJ0oigaTboBTU1Mb5+fnzwDAYFPeKyLqdQKSUjY6dD+KostBEHyz9YuZL5VKXXEcm3+1Z2vxz4nooBPQ5OTkpmq12uV5XrlQKMymAWmOUUoVACAAgDEiMtfXxGHdZVkAXHL+A9ncW3UO/QKKjCQ0t+MyGQAAAABJRU5ErkJggg==',
    yelloStar: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAyFJREFUWEftlj9oE2EYxp83aXMXdXEQCw5CsB0sDopDF8mlFUWti/9IESHttUWo4KRWrCgIBXXSuoi5VgVttAUHFayDubMgHRTBQVFIpZM6CdrS5Ei+V65ajW2S73ontYi3HOR73uf58X7fd3kJS+yhJcaDfw+I0/o6m3AZwCQHuVvd0j/up+u+O2Rb7VeYucuBIKA/pBn6XwPKjnbUUUG8LQYQQmjhxgHLK5SvDuVMvRfAyTnhQ4pmHFh0IE4namwKfigVLJhi4VjS9ALluUM5q+0MmM6WCmXGIzVm7Fg0IH7eucyeLExVCvTaJU8dqtSdWUgCzJBmxBbaJVdAnE6odpAiQaqKiAJHGHzJVRCjGxAZCgQy1VPZDO289UVWNw8oP9rR7ISCOMKMCIAIEUWYOSwzq7ROoLwAjwOcAVNm5k2UUTXjfnHdb0BZs+0qgTr9BC+0loDrIc1oLdrqXxY5U78LYP9CTX3pCS+UqLG5NFC6dR9RcJDBVb5CXBY728hcaFFiA8MlgZwfs6a+OwAMMrDcpa8nGQFTAmipeIZmnbNW2zZiSgFY6SlNXvSZieNqtP/xXGnZaz/9pDVKAUoRqEbu717B4I8sOF7uD7jid8hOtzcIcIoIa91HllcyYyIAiodiybFyKumH0bb0jYKRIqDODxQD7wKEeChqvKz8vXKR8uNMjbiQlpVwgberTfPPjOszVCzMmboz8zizj/dH4ITSaFyQGUi3zDHIWfowGHtlZpL124pmHJR5uAMydWdM9XWGALxWNKP+TwGxzMjNuqIZ0gZIBTkrsQEcfOUmUKohWq9Ek2983TLb1A8xcLNimOBzCKJQbqT9WcsUV2LJO76AsqZ+noDjpU34YmjV1x6qH7Kd9ZnRdip/rDwY9Spa8pQvoJylPwBjV7EJgfqq1XAPNfSVnAB5rH21Pc1HQOgprmPGQzVmNPsCKu4QAdfsPJ1esTX5SXpenMnBStQGEOxixtHver6naP17fAHxs8Nrsrl8LQS/DzcZE25A5mrsp62bIAINopAfUZtuZHwBeQHwUyO99n7MvdT+B5J17Rt8DiM07n1e9QAAAABJRU5ErkJggg==',
    headPotraitPic: '',
    completedCourseNum: 0,
    completedCourseRate: "0%",
    completedPaperNum: 0,
    completedPaperRate: "0%",
    courseStarLevel: 0,
    paperStarLevel: 0,
    totalCourseNum: 0,
    totalPaperNum: 0,
    isManager: false,
    isStaff: false,
    avgScore: 0,
    lessThan60PeopleNum: 0,
    between60And70PeopleNum: 0,
    between70And80PeopleNum: 0,
    between80And90PeopleNum: 0,
    moreThan90PeopleNum: 0,
    courseCompletedLearnerNum: 0,
    courseCompletedLearnerRate: 0,
    courseLearnerNum: 0,
    courseLearnerRate: 0,
    courseStarLevel1: 0,
    examCompletedExamineeNum: 0,
    examCompletedExamineeRate: 0,
    examStarLevel: 0,
    examineeNum: 0,
    examineeRate: 0,
    totalPeopleNum: 0,
    ec: {
      onInit: initChart
    }
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(app.globalData, 'app.globalData app.globalData')
    
    if (app.globalData.curRole === '企业管理') {
      let paperStarLevel=app.globalData.curEvaluate.examStarLevel
      this.setData({
        isManager: true,
        paperStarLevel:paperStarLevel,

        ...app.globalData.curEvaluate
      })
    }
    if (app.globalData.curRole === '企业员工') {
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/learningEvaluation/evaluatePerson',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          console.log(res, 'app.globalData')
          this.setData({
            completedCourseNum: res.data.completedCourseNum,
            completedCourseRate: res.data.completedCourseRate,
            completedPaperNum: res.data.completedPaperNum,
            completedPaperRate: res.data.completedPaperRate,
            courseStarLevel: res.data.courseStarLevel,
            paperStarLevel: res.data.paperStarLevel,
            totalCourseNum: res.data.totalCourseNum,
            totalPaperNum: res.data.totalPaperNum
          })
        }
      })
      this.setData({
        isStaff: true
      })
    }
   
    console.log(app.globalData.curRole, 'app.globalData.curRole')
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '学习评价'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#0A0B9F',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})