// pages/hwapprovallist/hwapprovallist.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    hwapprovalSerchIcon: 'http://39.102.232.151:8030/cover/企业搜索icon.png',
    approvalenterImgUrl: 'http://39.102.232.151:8030/cover/证书企业icon.png',
    approvalList: [],
    companyId: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options,'这里吗')
    this.data.companyId = options.companyId
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/pageEnterprise',
      method: 'get', 
      header: {
        Authorization: app.globalData.Authorization,
        
      },
      data: {
        page: 0,
        size: 10,
        county:app.globalData.appCounty
      },
      success: async (res) => {
        console.log(res, 'wx.request')
        let result = [...res.data.content]
        let proArr = []
        result.forEach(item => {
          proArr.push(new Promise((resolve, reject) => {
            wx.request({
              url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/page',
              method: 'get',
              header: {
                Authorization: app.globalData.Authorization
              },
              data: {
                companyId: item.enterpriseId
              },
              success: (res1) => {
                item.approvalSum = res1.data.content.length
                resolve()
              },
              fail: () => {
                reject()
              }
            })
          })) 
          
        })
        await Promise.all(proArr)
        this.setData({
          approvalList: result.map(item => {
            return {
              companyName: item.enterpriseName,
              companyId: item.enterpriseId,
              approvalSum: item.approvalSum
            }
          })
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '危险作业审批'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  /**
   * 选择开始日期
   */
  selectStartDate(event) {
    this.setData({
      curSelectStartDate: event.detail.value
    })
  },
  selectEndDate(event) {
    this.setData({
      curSelectEndDate: event.detail.value
    })
  },
  jumpToCat(event) {
    wx.navigateTo({
      url: '/pages/hwcatapproval/hwcatapproval?id=123'
    })
  },
  searchEnter(event) {
    // event.detail.value
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/pageEnterprise',
      method: 'get', 
      header: {
        Authorization: app.globalData.Authorization,
      
      },
      data: {
        page: 0,
        size: 10,
        enterpriseName: event.detail.value,
        county:app.globalData.appCounty

      },
      success: async ( res ) => {
        console.log(res, 'helloworld')
        let result = [...res.data.content]
        let proArr = []
        result.forEach(item => {
          proArr.push(new Promise((resolve, reject) => {
            wx.request({
              url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/page',
              method: 'get',
              header: {
                Authorization: app.globalData.Authorization
              },
              data: {
                companyId: item.enterpriseId
              },
              success: (res1) => {
                item.approvalSum = res1.data.content.length
                resolve()
              },
              fail: () => {
                reject()
              }
            })
          })) 
          
        })
        await Promise.all(proArr)
        this.setData({
          approvalList: result.map(item => {
            return {
              companyName: item.enterpriseName,
              companyId: item.enterpriseId,
              approvalSum: item.approvalSum
            }
          })
        })
      }
    })
  },
  toAddApproval() {
    if (app.globalData.curRole !== '企业管理') {
      wx.showToast({
        title: '不具备权限',
        icon: 'error'
      })
      return
    }
    wx.navigateTo({
      url: '/pages/addapproval/addapproval?companyId=' + this.data.companyId
    })
  },
  tohwapprovals(event) {
    
    console.log(event.target.dataset.index.companyId, 'hehehehe')
    console.log(app.globalData.curRole, 'app.globalData.curRole')
    if (app.globalData.curRole === '超级管理员'||app.globalData.curRole === '企业管理'||app.globalData.curRole === '政府'||app.globalData.curRole === '运营商') {
      wx.navigateTo({
        url: '/pages/hwapprovals/hwapprovals?companyId=' + event.target.dataset.index.companyId,
      })
    } else {
      wx.showToast({
        title: '不具备权限',
      })
    }
    
  }
})