// pages/approval/approval.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    approvalSerchIcon: 'http://39.102.232.151:8030/cover/企业搜索icon.png',
    approvalList: [
      
    ],
    companyId: '',
    curRole: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      curRole: app.globalData.curRole
    })
    this.data.companyId = options.companyId
    console.log(options, 'options in hwapprovals')
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/page',
      method: 'get',
      data: {
        companyId: this.data.companyId
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res, 'api/dangerJobRepost')
        this.setData({
          approvalList: [...res.data.content.map(item => {
            return {
              name: item.name,
              uploadDate: item.uploadDate,
              validDate: item.time,
              id: item.id,
              filePath: item.filePath,
              companyId: item.companyId
            }
          })]
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '危险作业备案'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/page',
      method: 'get',
      data: {
        companyId: this.data.companyId
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res, 'api/dangerJobRepost')
        this.setData({
          approvalList: [...res.data.content.map(item => {
            return {
              name: item.name,
              uploadDate: item.uploadDate,
              validDate: item.time,
              id: item.id,
              filePath: item.filePath,
              companyId: item.companyId
            }
          })]
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  navigateToapproval() {
    wx.navigateTo({
      url: '/pages/approvalitem /approvalitem',
      success: function(event) {}
    })
  },
  pullDownRefresh() {
    console.log('pullDownRefresh pullDownRefresh pullDOwnRefresh')
    setTimeout(() => {
      this.setData({
        isPullDown: false
      })
    }, 500)
  },
  addEnterpriseapproval() {
    if (app.globalData.curRole === '企业管理') {
      wx.navigateTo({
        url: '/pages/addapproval/addapproval?companyId=' + this.data.companyId,
      })
    } else {
      wx.showToast({
        title: '不具备权限',
      })
    }
  },
  searchApproval(event) {
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/page',
      method: 'get',
      data: {
        companyId: this.data.companyId,
        jobName: event.detail.value
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        this.setData({
          approvalList: [...res.data.content.map(item => {
            return {
              name: item.name,
              uploadDate: item.uploadDate,
              validDate: item.time,
              id: item.id,
              filePath: item.filePath,
              companyId: item.companyId
            }
          })]
        })
      }
    })
  },
  viewFile(event) {
    console.log(event, 'event event')
    const tofilePath = event.currentTarget.dataset.index.filePath
    const index1 = tofilePath.indexOf('\\')
    const index2 = tofilePath.indexOf('\\', index1 + 1)
    const index3 = tofilePath.indexOf('\\', index2 + 1)
    const resultFilePath = tofilePath.substr(index3)
    if (!resultFilePath.endsWith('.pdf')) {
      wx.previewImage({
        urls: [app.globalData.appBaseUrlV3 + resultFilePath],
      })
    } else {
      wx.showLoading({
        title: '正在加载',
      })
      wx.downloadFile({
        url: app.globalData.appBaseUrlV3 + resultFilePath,
        success: (res) => {
          console.log(res, 'realdownloadfile')
          if (res.tempFilePath.endsWith('.pdf')) {
            // this.setData({})
            wx.openDocument({
              filePath: res.tempFilePath,
              showMenu: true
            })
          } else {
            // this.setData({
            //   isShowImg: true,
            //   showImgSrc: res.tempFilePath
            // })
            wx.previewImage({
              urls: [res.tempFilePath],
            })
          }
        },
        complete: () => {
          console.log('调用了吗 调用了吗')
          wx.hideLoading()
        },
        fail: (res) => {
          console.log('fail fail fail ',  res)
          console.log('fail fail fail')
        }
      })
    }
  },
  viewWork(event) {
    // console.log(event,'eeeeeee')
    const tofilePath = event.currentTarget.dataset.index.filePath
    const index1 = tofilePath.indexOf('\\')
    const index2 = tofilePath.indexOf('\\ht', index1 + 1)
    const index3 = tofilePath.indexOf('\\', index2 + 1)
    const resultFilePath = tofilePath.substr(index3)
    if (!resultFilePath.endsWith('.pdf')) {
      wx.previewImage({
        urls: [app.globalData.appBaseUrlV3 + resultFilePath],
      })
    } else {
      wx.showLoading({
        title: '正在加载',
      })
      wx.downloadFile({
        url: app.globalData.appBaseUrlV3 + resultFilePath,
        success: (res) => {
          console.log(res, 'realdownloadfile')
          if (res.tempFilePath.endsWith('.pdf')) {
            // this.setData({})
            wx.openDocument({
              filePath: res.tempFilePath,
              showMenu: true
            })
          } else {
            this.setData({
              isShowImg: true,
              showImgSrc: res.tempFilePath
            })
            wx.previewImage({
              urls: [res.tempFilePath],
            })
          }
        },
        complete: () => {
          console.log('调用了吗 调用了吗')
          wx.hideLoading()
        },
        fail: (res) => {
          console.log('fail fail fail ',  res)
          console.log('fail fail fail')
        }
      })
    }
  },
  deleteWork(event) {
    //event.currentTarget.dataset.index.id
    wx.showModal({
      title: '提示',
      content: '是否删除所选项',
      success: (res) => {
        if (res.confirm) {
          wx.showLoading({
            title: '正在删除',
          })
          wx.request({
            url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport',
            method: 'DELETE',
            header: {
              Authorization: app.globalData.Authorization
            },
            data: [event.currentTarget.dataset.index.id],
            success: (resd) => {
              if (resd.statusCode === 204) {
                wx.showToast({
                  title: '删除成功',
                })
                wx.request({
                  url: app.globalData.appBaseUrlV2 + '/api/dangerJobReport/page',
                  method: 'get',
                  data: {
                    companyId: this.data.companyId
                  },
                  header: {
                    Authorization: app.globalData.Authorization
                  },
                  success: (res) => {
                    console.log(res, 'api/dangerJobRepost')
                    this.setData({
                      approvalList: [...res.data.content.map(item => {
                        return {
                          name: item.name,
                          uploadDate: item.uploadDate,
                          validDate: item.time,
                          id: item.id,
                          filePath: item.filePath,
                          companyId: item.companyId
                        }
                      })]
                    })
                  }
                })
              }
            },
            complete: () => {
              wx.hideLoading()
            }
          })
        }
      }
    })
  },
  downloaFile(event) {
    const tofilePath = this.data.certifyList[event.target.dataset.index].filepath
    const index1 = tofilePath.indexOf('\\')
    const index2 = tofilePath.indexOf('\\', index1 + 1)
    const index3 = tofilePath.indexOf('\\', index2 + 1)
    const index4 = tofilePath.indexOf('\\', index3 + 1)
    const picFilePath = tofilePath.substr(index4 + 1)
    const index5 = picFilePath.indexOf('.')
    const picFilePath2 = picFilePath.substr(index5)
    const resultFilePath = tofilePath.substr(index3)
    console.log(app.globalData.appBaseUrlV3 + resultFilePath, 'resultFilePath')
    wx.showLoading({
      title: '正在加载',
    })
    console.log(picFilePath, 'picFilePath picFilePath')
    console.log(picFilePath2, 'picFilePath2 picFilePath2')
    console.log(`${wx.env.USER_DATA_PATH}`)
    const myPath = new Date().getTime() + picFilePath2
    const myPath2 = `${wx.env.USER_DATA_PATH}/${myPath}`
    wx.downloadFile({
      url: app.globalData.appBaseUrlV3 + resultFilePath,
      filePath: myPath2,
      success: (res) => {
        console.log(res, 'realdownloadfile')
        wx.showToast({
          title: '下载成功',
          icon: 'success',
          duration: 1500
        })
        wx.hideLoading()
        // wx.saveFile({
        //   tempFilePath: res.tempFilePath,
        //   success: (res1) => {
        //     console.log(res1, 'tempFielPath tempFilePath')
        //     wx.showToast({
        //       title: '下载成功',
        //     })
        //   },
        //   fail: (res1) => {
        //     wx.showToast({
        //       title: '下载失败',
        //     })
        //   }
        // })
      },
      complete: () => {
        console.log('调用了吗 调用了吗')
        // wx.hideLoading()
      },
      fail: () => {
        console.log('fail fail fail')
        wx.showToast({
          title: '下载失败',
          icon: 'error'
        })
        wx.hideLoading()
      }
    })
  },
  hideImageShow() {
    this.setData({
      isShowImg: false
    })
  }
})