// pages/teach/teach.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    yesicon: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAsVJREFUWEfNVz1oFEEU/t7iiQoaRG0EiVoIlnY2WgUsbnM7m5BTItFCQVSCjYWgnYpFGiGiFhaiKLnE7O5d7sQilTZWWgoW/hYWRkIUf+Bkn8xkN9zt7dzuXfaIW92x733ft/PevPmGkPIplAub/b80AIOOAtgHYDuAbUH6NwALAN7C55KxjucrVuVHGmhKCso79n4iHgdwDMDWpPjg/SKAKWaarA25b9rltBWQ96xrBBoHY0tK4uYwwncGT9ZE+YouXyvAdMVzAIe6Im5NelG1vcNxWLECTFd8DWqcEb+CWaja3o4oYIuAvCveE7A7S+YQi4EPNdvb04jdJGDQE9PMGOkFeYhJhJk54RVX/oc/VMMxXe4l+cpKEF8PG1OtgNpqBr/suts7VS13h08H5RZVAkxX3AZwtlOchPg5ZnpIxLLmcmWjW/lO1fbO0cD0SN+GXP0jgL6sBETrbLriGYAjEfylP/VcPw26YoyBB70il7i65ibgBJmueAJgOAsB0S9X5K4oMlDS4M9KAa8AHFitgFhyzxplpkdtsF9LAZ8A7NIEhY00Jj9GO88jezvYWSeJ+H7Ch32WAn4C2BQNjE4tbR3jyF1xioB7KVb1l1aATF7vGzudYedLCBQVoVn2M8x0NwW5DFECtCWIJ1ge13HvTM8+D+ZbKcllmCpB2ybUiWic58EwuwDgZgfkMlQ14RQAabO0T5yIxuC8Y10kookOyWV4icxZy4ZBTlKyToTp2JdAfCMpP/a9z0OkzKZvyFGc6PdiRqy0Wle7IgcWDcPv7+YwegpgAsynQXS8S3KZtnwYBUNjbY9jJWItDUm4jBk7YV11mhxyiyntkSMOxbQ441hb3gtnHOeIpSrtxSRLh9xukP2/V7OwaA2X09EOfOMSgMervpw2trE0rxtz9QIDFoC9muv5OwLKv+u5ynxxRopIfP4Bc1M7FOUcJGEAAAAASUVORK5CYII=',
    erroricon: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAqpJREFUWEfNlz2IE1EQx/+zeyFyWCgW6lWKnYJmT9ErbMy+5PBC/CjUQ5vDQg4LsVGuELQ5BBEsRMVr0qiHnmChyRHyAluICB63aqGNqIX4gYoiyhnc7JON2bgbs9mPS4gLaTbz/vPbefNm5hEiPE8zmeW/KpVVErDSBD7E4vH3G/P5LxGkQEEWPRseXv3TMEYI2C6IsgSsaF4ngM8kxF0B3F/S11dYXyy+C6LdFsByXKlWjwCwfgNBBOs2bwFMxWV5yg/EE0Bn7CCEmATRmhCOm01fATilcH7DS6MlwDxjEwScXYRj11ICLiY4P9ZK7x8APZXaByFudcq5QyencH64WdcF0EXntt/zCucnnBANgLl0eptsmg+78OUuSQEcHeT8iv2yAaAzdg3AoW4DAHheicWGhmZnv1m+agDzyeROkqRCG+cnAfQDOOMLSHQbQlwCcAfAMg9762RM/gVQ1WkiGvUSj8vygHWedcZO+0Dc+2oYe3domqEzpgNIeGi+VDhfVwOYy2b75YWFj/Uv9GKYUTjfb/3pBSGActww9mzQtO8BQAGijFIqFehJOj1qmua0b2gBbwghHlSr1d1bNO1TIOcABNHVwVJpnHTGzgFwHY02MK0gdMkwdm3StDdBndf1HymcbyVdVXMgGgsQAdvEBWHK8vXNxeKLkM4BIV4r5fJaKwJ5ACMhACzTBkS7vPDR/KFwvvQ/AFjEFjxW1QOJcvlmpCg4tiBaEiaTY5CknHM7QubBnySMcgznU6lxEqJRz6NANI5hhEJ0HMCFFgnmW6xca+xCVOsFAUtxgEHFCRGsFHe8GQEzAC6Hakb1LO5dO7YAej6Q1KLQvXnQzj/vkcy26CKE/1BqQwTI9lCtI9RY3ohELy8mNkRPr2bOGPfscuq10Z28nv8GJo17MKYlOKAAAAAASUVORK5CYII=',
    searchIcon: 'data:image/png;base64,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',
    animationSearch: {},
    teachList: [
      {
        cover: 'http://39.102.232.151:8030/cover/teach1.jpg',
        introduce: '请大家认真听讲，认真学习、记录，该培训视频和考试要求在一周内完成。-----山东弘煜质检技术服务有限公司祝大家顺利取证',
        title: '安全教育培训课程（一） ',
        sum: 6,
        isLearnedSum: 3,
        validDate: 6,
        price: 300,
        isBuyed: false,
        courses: [
          {
            title: '安全生产培训教材',
            fileType: 'pdf',
            fileUrl: '',
            process: 100
          },
          {
            title: '2号令生产安全事故应急预案管理办法',
            fileType: 'pptx',
            fileUrl: '',
            process: 100
          },
          {
            title: '安全管理与安全防护（一）',
            fileType: 'mp4',
            fileUrl: 'http://39.102.232.151:8030/video/8.mp4',
            process: 100
          },
          {
            title: '安全管理与安全防护（二）',
            fileType: 'mp4',
            fileUrl: 'http://39.102.232.151:8030/video/9.mp4',
            process: 54
          },
          {
            title: '安全管理与安全防护（三）',
            fileType: 'mp4',
            fileUrl: 'http://39.102.232.151:8030/video/10.mp4',
            process: 50
          }
        ]
      },
      {
        cover: 'http://39.102.232.151:8030/cover/teach2.jpg',
        introduce: '请大家认真听讲，认真学习、记录，该培训视频和考试要求在一周内完成。-----山东弘煜质检技术服务有限公司祝大家顺利取证',
        title: '安全教育培训课程（二）',
        sum: 6,
        isLearnedSum: 3,
        validDate: 6,
        price: 300,
        isBuyed: false,
        courses: [
          {
            title: '安全生产培训教材',
            fileType: 'pdf',
            fileUrl: '',
            process: 100
          },
          {
            title: '2号令生产安全事故应急预案管理办法',
            fileType: 'mp4',
            fileUrl: '',
            process: 100
          },
          {
            title: '安全管理与安全防护（一',
            fileType: 'mp4',
            fileUrl: '',
            process: 100
          },
          {
            title: '安全管理与安全防护（二）',
            fileType: 'mp4',
            fileUrl: '',
            process: 54
          },
          {
            title: '安全管理与安全防护（三）',
            fileType: 'mp4',
            fileUrl: '',
            process: 50
          },
          {
            title: '应急管理部政策法规司新安全生产法修改权威解读',
            fileType: 'wmv',
            fileUrl: '',
            process: 0
          }
        ]
      }
    ]
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '在线培训'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    // 获取所有课程
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/onlineTraining/pageCourse',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        page: 0,
        size: 9999,
        county:app.globalData.appCounty
      },
      success: (res) => {
        console.log(res, 'authorization authorization  authorizatoin')
        let courses = []
        courses = [...res.data.content]
        console.log(courses, 'courses courses courses courses')
        for (let i = 0; i < courses.length; i++) {
          courses[i].coursehour = []
          courses[i].sum = 0
          courses[i].isLearnedSum = 0
          courses[i].validDate = 6
        }
        for (let i = 0; i < courses.length; i++) {
          wx.request({
            url: app.globalData.appBaseUrlV2 + '/api/onlineTraining/findLesson',
            method: 'get',
            header: {
              Authorization: app.globalData.Authorization
            },
            data: {
              page: 0,
              size: 9999,
              pid: courses[i].id
            },
            success: (res1) => {
              console.log(res1, 'coursehour coursehour')
              courses[i].coursehour = [...res1.data]
              courses[i].sum = courses[i].coursehour.length
              courses[i].isLearnedSum = courses[i].coursehour.filter(item => parseInt(item.speed) > 98).length
              courses[i].cover = app.globalData.appBaseUrlV3 + '/online-training/cover/' + courses[i].courseCoverFilePath.split('\\online-training\\cover\\')[1]
              courses[i].introduce = courses[i].courseBriefIntroduction
              this.setData({
                teachList: courses
              })
            },
            fail: () => {}
          })
        }
      },
      fail: () => {}
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {
    // if (this.repAnimation) {
    //   this.repAnimation.width('50%').step()
    //   this.setData({
    //     animationSearch: this.repAnimation.export()
    //   })
    // }
  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  /**
   * 用户输入课程名称
   */
  inputSearchCourse(event) {
    console.log(event.detail.value, 'ehheheheheh')
    this.searchCourse = event.detail.value
  },
  /**
   * 用户搜索课程
   */
  searchTeachCourse(event) {
    console.log(event, 'search______________>>>>>>course')
    
        // 获取所有课程
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/onlineTraining/pageCourse',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        page: 0,
        size: 9999,
        courseTitle: event.detail.value,
        county:app.globalData.appCounty
      },
      success: (res) => {
        console.log(res, 'authorization authorization  authorizatoin')
        let courses = []
        courses = [...res.data.content]
        console.log(courses, 'courses courses courses courses')
        for (let i = 0; i < courses.length; i++) {
          courses[i].coursehour = []
          courses[i].sum = 0
          courses[i].isLearnedSum = 0
          courses[i].validDate = 6
        }
        for (let i = 0; i < courses.length; i++) {
          wx.request({
            url: app.globalData.appBaseUrlV2 + '/api/onlineTraining/findLesson',
            method: 'get',
            header: {
              Authorization: app.globalData.Authorization
            },
            data: {
              page: 0,
              size: 9999,
              pid: courses[i].id
            },
            success: (res1) => {
              console.log(res1, 'coursehour coursehour')
              courses[i].coursehour = [...res1.data]
              courses[i].sum = courses[i].coursehour.length
              courses[i].isLearnedSum = courses[i].coursehour.filter(item => parseInt(item.speed) > 98).length
              courses[i].cover = app.globalData.appBaseUrlV3 + '/online-training/cover/' + courses[i].courseCoverFilePath.split('\\online-training\\cover\\')[1]
              courses[i].introduce = courses[i].courseBriefIntroduction
              this.setData({
                teachList: courses
              })
            },
            fail: () => {}
          })
        }
      },
      fail: () => {}
    })
  },
  /**
   * 获取焦点
   */
  searchCoursefocus(event) {
    const repAnimation = wx.createAnimation({
      duration: 50,
      timingFunction: 'step-start'
    })
    this.repAnimation = repAnimation
    repAnimation.translateX('0rpx').width('100%').step()
    this.setData({
      animationSearch: repAnimation.export()
    })
  },
  /**
   * 跳转到真实课程
   */
  LinkToCourse(event) {
    console.log(event, 'LinkToCourse LinkToCourse LinkToCourse LinkToCourse')
    console.log(event.target.dataset.index, 'event.target.dataset.index')
    app.globalData.currentCourse = this.data.teachList[event.target.dataset.index]
    wx.navigateTo({
      url: '/pages/course/course',
      success: function(event) {}
    })
  }
})