// pages/trainimgenter/trainimgenter.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    isPullDown: false,
    enterSearchImgUrl: 'http://39.102.232.151:8030/cover/企业搜索icon.png',
    enterImgUrl: 'http://39.102.232.151:8030/cover/证书企业icon.png',
    curRole: app.globalData.curRole,
    searchEnter: '',
    enterList: [
    ]
  },

  /**
   * 生命周期函数--监听页面加载 
   */
  onLoad: function (options) {
    this.setData({
      curRole: app.globalData.curRole
    })
    let params = {
      county:app.globalData.appCounty,
      page: 0,
      size: 10
    }
    if (this.data.searchEnter) {
      params.name = this.data.searchEnter
    }
    wx.showLoading({
      title: '正在加载',
    })
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/trainImage/pageEnterprise',
      method: 'get',
      data: params,
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res, 'wx.request wx.request wx.request')
        this.setData({
          enterList: [...res.data.content.map(item => {
            return {
              companyName: item.name,
              companyId: item.id,
              trainImgSum: item.trainImageNum
            }
          })]
        })
      },
      complete: () => {
        wx.hideLoading()
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '培训影像管理'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  pullDownRefresh() {
    setTimeout(() => {
      this.setData({
        isPullDown: false
      })
    },1000)
  },
  toTrainImg(event) {
    console.log(event.currentTarget, 'event.currentTarget event.currentTarget')
    wx.navigateTo({
      url: '/pages/trainimg/trainimg?companyId=' + event.currentTarget.dataset.index.companyId,
    })
  },
  inputSearchName(event) {
    this.data.searchEnter = event.detail.value
  },
  searchEnterByName() {
    let params = {
      county:app.globalData.appCounty,
      page: 0,
      size: 10
    }
    if (this.data.searchEnter) {
      params.name = this.data.searchEnter
    }
    wx.showLoading({
      title: '正在加载',
    })
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/trainImage/pageEnterprise',
      method: 'get',
      data: params,
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res, 'wx.request wx.request wx.request')
        this.setData({
          enterList: [...res.data.content.map(item => {
            return {
              companyName: item.name,
              companyId: item.id,
              trainImgSum: item.trainImageNum
            }
          })]
        })
      },
      complete: () => {
        wx.hideLoading()
      }
    })
  }
})