// pages/addcertify/addcertify.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    addcertifyiconImgUrl: 'http://39.102.232.151:8030/cover/添加证书icon.png',
    certifytype: 1,
    certifyName: '',
    uploadDate: '2021-09-09',
    validDate: '2021-09-09',
    certifyFile: null,
    fileName: '请选择要上传内容'
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.data.companyId = options.companyId
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '新增企业证书'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  taptype1() {
    this.setData({
      certifytype: 1 
    })
  },
  taptype2() {
    this.setData({
      certifytype: 2
    })
  },
  taptype3() {
    this.setData({
      certifytype: 3
    })
  },
  taptype4() {
    this.setData({
      certifytype: 4
    })
  },
  inputCertifyName(event) {
    console.log(event, 'inputCertifyName')
    this.data.certifyName = event.detail.value
  },
  inputUploadTime(event) {
    console.log(event, 'inputUploadTime')
    this.setData({
      uploadDate: event.detail.value
    })
  },
  inputValidTime(event) {
    console.log(event, 'inputValidTime')
    this.setData({
      validDate: event.detail.value
    })
  },
  chooseCertify(event) {
    console.log(event, 'chooseCertify')
    wx.chooseMessageFile({
      count: 1,
      success: (res) => {
        console.log(res, 'chhofhasdhf s')
        this.data.certifyFile = res.tempFiles[0].path
        this.setData({
          fileName: res.tempFiles[0].name
        })
      }
    })
  },
  uploadCertify(event) {
    console.log(event, 'uploadCertify')
    if (!this.data.certifyName) {
      wx.showToast({
        title: '请输入证书名称',
      })
      return
    }
    if (!this.data.uploadDate) {
      wx.showToast({
        title: '请选择上传时间',
      })
      return
    }
    if (!this.data.validDate) {
      wx.showToast({
        title: '请选择有效时间',
      })
      return
    }
    if (!this.data.certifyFile) {
      wx.showToast({
        title: '请选择证书文件',
      })
    }
    let formObj = {
      category: this.data.certifytype=== 1? '应急预案' : (this.data.certifytype === 2?'双体系证书':  (this.data.certifytype === 3?'标准化': '责任清单')),
      companyId: this.data.companyId,
      expirationDate: this.data.validDate,
      uploadDate: this.data.uploadDate,
      name: this.data.certifyName
    }
    console.log(this.data.certifyFile)
    console.log(formObj)
    const uploadTask = wx.uploadFile({
      filePath: this.data.certifyFile,
      name: 'file',
      url: app.globalData.appBaseUrlV2 + '/api/enterpriseCertificate',
      formData: formObj,
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res, 'uploadCertify')
        if (res.statusCode === 201) {
          wx.navigateBack()
          wx.showToast({
            title: '上传成功',
          })
        } else {
          wx.showToast({
            title: '上传失败',
            icon: 'error'
          })
        }
        
      },
      fail: (res) => {
        console.log(res, 'faile res uploadFile')
        wx.showToast({
          title: '上传失败',
          icon: 'error'
        })
      }
    })
    uploadTask.onProgressUpdate(event => {
      console.log(event, 'hehe onProgressUpdate')
    })
  }
})