// pages/advice/advice.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    adviceList: [
    ],
    advTot:null,
    curPage: 0,
    curPageSize: 10,
    isPullDown: false
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.request({
      url: app.globalData.appBaseUrl + '/api1/notice/findOwnTag',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        county:app.globalData.appCounty,
        page: this.data.curPage,
        size: this.data.curPageSize
        //sort: 'noticeId,desc'
      },
      success: (res) => {
        console.log(res.data.content.length, 'app.globalData.appBaseUrlV2')
        this.setData({
          adviceList: res.data.content,
          advTot:res.data.content.length
        })
      },
      complete: (res) => {}
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '通知公告'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  
  /**
   * 点击跳转通知子项
   */
  clickadvice(event) {
    console.log(event.target.dataset.index)
    app.globalData.currentAdviceItem = this.data.adviceList[event.target.dataset.index]
    this.data.adviceList[event.target.dataset.index].isRead = true
    this.setData({
      adviceList: this.data.adviceList
    })
    wx.navigateTo({
      url: '/pages/adviceItem/adviceItem',
      success: (res) => {
        res.eventChannel.emit('acceptDataFromOpenerPage1', {
          adviceId: this.data.adviceList[event.target.dataset.index].noticeId
        })
      }
    })
  },
  pullDownRefresh() {
    this.data.curPageSize += 10
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/notice/findOwnTag',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        county:app.globalData.appCounty,
        page: this.data.curPage,
        size: this.data.curPageSize
        // sort: 'noticeId,desc'
      },
      success: (res) => {
        this.setData({
          isPullDown: false,
          adviceList: [...res.data.content]
        })
      },
      complete: (res) => {}
    })
  }
})