// pages/lawItem/lawItem.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    title: '',
    depart: '',
    time: '',
    strips: [],
    thumsup: 1122,
    readSum: 3344,
    content: '',
    isThumsUp: false,
    lawId: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    // options.query
    console.log(options.query)
    const eventChannel = this.getOpenerEventChannel()
    eventChannel.on('acceptDataFromOpenerPage', (data) => {
      console.log(data.lawId, 'data data data')
      this.data.lawId = data.lawId
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api/thLaw/findLawDetails',
        method: 'get',
        data: {
          lawId: data.lawId
        },
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          if (res.data.thLawChapterDtoList && res.data.thLawChapterDtoList.length) {
            this.setData({
              content: res.data.thLawChapterDtoList[0].lawChapter
            })
          }
          this.setData({
            title: res.data.lawTitle,
            depart: res.data.lawPublisher,
            time: res.data.lawDate,
            thumsup: res.data.likeNum,
            readSum: res.data.readNum
          })
          wx.setNavigationBarTitle({
            title: res.data.lawTitle
          })
        }
      })
    })
    // wx.request({
    //   url: 'api/thLaw/findLawDetails',
    //   method: 'GET',
    //   data: {

    //   }
    // })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {
    const promise = new Promise(resolve => {
      setTimeout(() => {
        resolve({
          title: '自定义转发'
        })
      }, 2000)
    })
    return {
      title: '自定义转发标题',
      path: '/page/user?id=123',
      promise
    }
  },
  // 分享到朋友圈
  onShareTimeline: function() {
    // return {
    //   title: '',
    //   query: '',
    //   imageUrl: ''
    // }
  },

  /**
   * 用户点击收藏
   */
  onAddToFavorites: function() {
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/thLaw/collect',
      method: 'get',
      data: {
        lawId: this.data.lawId
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: () => {},
      fail: () => {},
      complete: () => {}
    })
    /**
     * return {
     *  title: '',
     * imageUrl: '',
     * query: ''
     * }
     */
  },
  tapToThumsup() {
    if (this.data.isThumsUp === false) {
      this.setData({
        thumsup: this.data.thumsup + 1,
        isThumsUp: true
      })
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api/thLaw/like',
        method: 'get',
        header: {
          Authorization: app.globalData.Authorization
        },
        success: () => {},
        fail: () => {},
        complete: () => {}
      })
    }
  }
})