// pages/mettingaedit/mettingedit.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    mettingString:{
      meetingTime:'',
      content:'',
      shouldPeople:'',
      actualPeople:'',
      path:'',
      uploadTime:'',
      companyId:'',
      imgsrcurl:'',
      id:'',
      newString:'',
    },
     delFileNames:[],
      baseUrl:'',
      imgarr:[],
      sliceString:'',//截取并转义后的图片路径
      Splicing:[],
      
      Image:'',
      // 上传图片
      imgs: [],
      baseImg: [], // base64图片集合
      maxImg: 9, // 图片上传最高数量（根据需求设置）
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad(options) {
    console.log(options)
    this.data.baseUrl=app.globalData.appBaseUrl;
    console.log(this.data.baseUrl)
    var item = JSON.parse(options.params);
    console.log(item)
    this.data.imgarr = item.path.split(';');
    console.log(this.data.imgarr)
    const that = this;
    this.data.imgarr =item.path.slice(15).replace("\\", "\/");
    console.log(this.data.imgarr)//字符串
    // 拼接
     this.data.mettingString.newString=this.data.baseUrl+'/'+this.data.imgarr
    console.log(this.data.mettingString.newString)
    this.setData({
      curRole: app.globalData.curRole,
      mettingString:item,  
     newString: this.data.mettingString.newString
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow() {
    wx.setNavigationBarTitle({
      title: '企业晨会编辑',
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage() {

  },
  // 选择晨会时间
  selectMettingDate(event) {
    console.log(event.detail.value)
    this.setData({
      ['mettingString.meetingTime']:event.detail.value,
    });
  
  },
   //晨会内容
   inputContent(event) {
    console.log(event.detail.value)
    this.setData({
      ['mettingString.content']:event.detail.value,
    });
  },
  // 应参加人数
  inputPerson(event) {
    console.log(event.detail.value)
    this.setData({
      ['mettingString.shouldPeople']:event.detail.value,
    });
  },
   // 实际参加人数
   inpuTactualperson(event) {
    console.log(event.detail.value)
    this.setData({
      ['mettingString.actualPeople']:event.detail.value,
    });
   
  },
   // 上传图片
   chooseImg: function (e) {
    var that = this;
    var imgs = this.data.imgs;
    if (imgs.length >= 9) {
     this.setData({
      lenMore: 1
     });
     setTimeout(function () {
      that.setData({
       lenMore: 0
      });
     }, 2500);
     return false;
    }
    wx.chooseImage({
     // count: 1, // 默认9
     sizeType: ['original', 'compressed'], 
     sourceType: ['album', 'camera'], 
     success: function (res) {
      // 返回选定照片的本地文件路径列表，tempFilePath可以作为img标签的src属性显示图片
      var tempFilePaths = res.tempFilePaths;
      console.log(tempFilePaths);
      for(var str of tempFilePaths){
        wx.getFileSystemManager().readFile({
          filePath: str, // 选择图片返回的相对路径
          encoding: 'base64', //编码格式
          success: res1 => { // 成功的回调
            console.log(res1)
            var baseimg = 'data:image/png;base64,' + res1.data;
            var imgs = that.data.imgs;
            imgs.push(baseimg);
            that.setData({
              imgs: imgs
            });
            console.log(imgs);
          }
        })
      }
      return;
     }
     
    });
   },




   // 删除图片
   deleteImg: function (e) {
    var imgs = this.data.imgs;
    var index = e.currentTarget.dataset.index;
    imgs.splice(index, 1);
    this.setData({
     imgs: imgs
    });
   },
   // 预览图片
   previewImg: function (e) {
     //获取当前图片的下标
    var index = e.currentTarget.dataset.index;
     //所有图片
    var imgs = this.data.imgs;
    wx.previewImage({
     //当前显示图片
     current: imgs[index],
     //所有图片
     urls: imgs
    })
   },
   // 上传时间
   uploadTime(event) {
    console.log(event.detail.value)
    this.setData({
      ['mettingString.uploadTime']:event.detail.value,
    });
  },
  edit(){
    console.log(this.data.mettingString.id)
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api1/morningMeeting' ,
      method: 'PUT',
      data: {
        meetingTime: this.data.mettingString.meetingTime,//晨会时间
        actualPeople:this.data.mettingString.actualPeople,//实际参加人数
        shouldPeople:this.data.mettingString.shouldPeople,//应参加人数
        uploadTime:this.data.mettingString.uploadTime,//上传时间
        content:this.data.mettingString.content,//晨会内容
        companyId:this.data.mettingString.companyId,//id
        pic:this.data.imgs,//图片
        id: this.data.mettingString.id,
        "delFileNames": [
    
        ],
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res)
        if (res.statusCode === 204) {
          wx.showToast({
            title: '提交成功',
            icon:'success',
            duration: 1000
          })
          wx.navigateTo({
            url: '/pages/meeting/meeting',
          })
        } else if (res.statusCode === 400) {
          wx.showToast({
            title: '提交失败！',
            icon: 'error',
          })
        }
    }
  }) 
  }
 
})