// pages/home/home.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    topNavHeight: 40,
    // topPersonWidth: 20,
    topPersonHeight: 40,
    topStatusBar: 40,
    curRole: '',
    personCenterImgSrc: 'http://39.102.232.151:8030/cover/人像icon.png'
    // topNavWidth: 
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(app.globalData,'globalData')
    // wx.getSystemInfoAsync({
    //   success: (result) => {
    //     console.log(result, 'result result')
    //   },
    // })
    // tag 企业管理
    const sysInfo = wx.getSystemInfoSync()
    const rect = wx.getMenuButtonBoundingClientRect()
    console.log(sysInfo)
    console.log(rect)
    let toGetHeight = 0
    toGetHeight = (rect.top - sysInfo.statusBarHeight) * 2 + sysInfo.statusBarHeight + rect.height
    this.setData({
      curRole: app.globalData.curRole,
      topNavHeight: toGetHeight,
      topPersonHeight: rect.height - 2 * (rect.top - sysInfo.statusBarHeight)+10,
      topStatusBar: sysInfo.statusBarHeight
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '安全生产管理平台'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#ffffff',
      frontColor: '#000000'
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },

  /**
   * 跳转到法律法规
   */
  linkToLaw() {
    console.log(1)
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    wx.navigateTo(
      {
        url: '/pages/law/law',
        success: function(event) {
          console.log('跳转成功', event)
        }
      }
    )
  },
  /**
   * 跳转到通知通告
   */
  linkToAdvice() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    wx.navigateTo({
      url: '/pages/advice/advice',
      success: function(event) {
      }
    })
  },
  /**
   * 跳转到信息推送
   */
  linkToInfo() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    wx.navigateTo({
      url: '/pages/info/info',
      success: function(event) {}
    })
  },
  /**
   * 跳转警示教育
   */
  LinkToWarn() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    wx.navigateTo({
      url: '/pages/warnIndex/warnIndex',
      success: function(event) {}
    })
  },
  /**
   * 跳转到在线直播
   */
  LinkToLive() {
    wx.showToast({
      title: '开发中',
      icon: 'error',
      duration: 2000
    })
    // wx.navigateTo({
    //   url: '/pages/live/live',
    //   success: function(event) {}
    // })
  },
  /**
   * 跳转到在线培训
   */
  LinkToTeach() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    wx.navigateTo({
      url: '/pages/teach/teach',
      success: function(event) {}
    })
  },
  /**
   * 跳转到在线考试
   */
  LinkToExam() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    wx.navigateTo({
      url: '/pages/exam/exam',
      success: function(event) {}
    })
  },
  /**
   * 跳转到学习评价
   */
  LinkToEvaluate() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    if (app.globalData.curRole === '企业管理') {
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/learningEvaluation/evaluateEnterprise',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          console.log(res ,'app.globalData.curRole>>>>>>>>>>>>>>>>>>')
          app.globalData.curEvaluate = {
            ...res.data
          }
          wx.navigateTo({
            url: '/pages/evaluate/evaluate',
            success: function(event) {}
          })
        }
      })
    } else {
      wx.navigateTo({
        url: '/pages/evaluate/evaluate',
        success: function(event) {}
      })
    }

  },
  /**
   * 跳转到隐患管理
   */
  LinkToHD() {
    wx.navigateTo({
      url: '/pages/enterprise/enterprise',
      success: function(event) {}
    })
  },
  /**
   * 跳转到危险作业审批
   */
  LinkToHWApproval() {
    // wx.navigateTo({
    //   url: '/pages/hwapproval/hwapproval',
    //   success: function(event) {}
    // })
    if (app.globalData.userInfo.tag === '企业员工') {
      wx.showToast({
        title: '不具备权限',
        icon: 'error'
      })
      return
    }
    wx.navigateTo({
      url: '/pages/hwapprovallist/hwapprovallist',
      success: function(event) {}
    })
  },
  /**
   * 跳转到企业安全档案
   */
  LinkToCertify() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    if (app.globalData.userInfo.tag === '企业员工') {

      wx.showToast({
        title: '不具备权限',
        icon: 'error'
      })
      return
    }
    wx.navigateTo({
      url: '/pages/certifyenter/certifyenter',
      success: function(event) {}
    })
  },
  /**
   * 跳转到影像管理
   */
  LinkToPortrait() {
    // wx.showToast({
    //   title: '开发中',
    //   icon: 'error',
    //   duration: 2000
    // })
    wx.navigateTo({
      url: '/pages/portrait/portrait',
      success: function(event) {}
    })
    if (app.globalData.userInfo.tag === '企业员工') {
      wx.showToast({
        title: '不具备权限',
        icon: 'error'
      })
      return
    }
    wx.navigateTo({
      url: '/pages/trainimgenter/trainimgenter',
      success: function(event) {}
    })
  },
  /**
   * 跳转到个人中心
   */
  LinkToPersonCenter() {
    wx.navigateTo({
      url: '/pages/person/person',
      success: function(event) {}
    })
  }
})