// pages/hwapproval/hwapproval.js

let secureSupervisorContext = null;
let isButtonDown = false;
let sarrx = [];
let sarry = [];
let sarrz = [];
let ssarrx = [];
let ssarry = [];
let ssarrz = [];
let canvasw = 0;
let canvash = 0; 

let supervisorContext = null;

wx.getSystemInfo({
  success: function (res) {
    canvasw = res.windowWidth * 700 / 750; // 设备宽度
    canvash = res.windowWidth * 250 / 750;
  }
});

Page({

  /**
   * 页面的初始数据
   */
  data: {
    unitNamePic: '',
    reportDate: '',
    reserveDate: '',
    secureSupervisorSignDate: '',
    supervisorSignDate: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    const SelectQuery = wx.createSelectorQuery()
    const canvasElement = SelectQuery.select('#toSign')
    canvasElement.context(res => {
      secureSupervisorContext = res.context
    })
    
    const canvasSuperVisor = SelectQuery.select('#toSign2')
    canvasSuperVisor.context(res => {
      supervisorContext = res.context
    })
    SelectQuery.exec((res) => {
      console.log(res, 'xixixixi')
    })
  },
  canvasIdErrorCallback: function(e) {
    console.log(e.detail.errMsg)
  },
  canvasStartSign: function(event) {
    isButtonDown = true;
    sarrz.push(0);
    sarrx.push(event.changedTouches[0].x);
    sarry.push(event.changedTouches[0].y);
  },
  canvasStartSupervisorSign: function(event) {
    isButtonDown = true;
    ssarrz.push(0);
    ssarrx.push(event.changedTouches[0].x);
    ssarry.push(event.changedTouches[0].y)
  },
  canvasMoveSign: function(event) {
    if (isButtonDown) {
      sarrz.push(1)
      sarrx.push(event.changedTouches[0].x);
      sarry.push(event.changedTouches[0].y);
    }
    for (let i = 0; i < sarrx.length; i++) {
      if (sarrz[i] == 0) {
        secureSupervisorContext.moveTo(sarrx[i], sarry[i])
      } else {
        secureSupervisorContext.lineTo(sarrx[i],sarry[i])
      }
    }
    secureSupervisorContext.clearRect(0, 0, canvasw, canvash);
    secureSupervisorContext.setStrokeStyle('#000000');
    secureSupervisorContext.setLineWidth(4);
    secureSupervisorContext.setLineCap('round');
    secureSupervisorContext.setLineJoin('round');
    secureSupervisorContext.stroke();

    secureSupervisorContext.draw(false);
  },
  canvasMoveSupervisorSign: function(event) {
    if (isButtonDown) {
      ssarrz.push(1)
      ssarrx.push(event.changedTouches[0].x);
      ssarry.push(event.changedTouches[0].y);
    }
    for (let i = 0; i < ssarrx.length; i++) {
      if (ssarrz[i] == 0) {
        supervisorContext.moveTo(ssarrx[i], ssarry[i])
      } else {
        supervisorContext.lineTo(ssarrx[i],ssarry[i])
      }
    }
    supervisorContext.clearRect(0, 0, canvasw, canvash);
    supervisorContext.setStrokeStyle('#000000');
    supervisorContext.setLineWidth(4);
    supervisorContext.setLineCap('round');
    supervisorContext.setLineJoin('round');
    supervisorContext.stroke();

    supervisorContext.draw(false);   
  },
  canvasEndSign: function(event) {
    isButtonDown = false
  },
  cleardraw: function() {
    // 清除画布
    sarrx = []
    sarry = []
    sarrz = []
    secureSupervisorContext.clearRect(0, 0, canvasw, canvash)
    secureSupervisorContext.draw(true)
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '危险作业报告单'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    sarrx = []
    sarry = []
    sarrz = []
    ssarrx = []
    ssarry = []
    ssarrz = []

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  /**
   * 选择报告日期
   */
  pickReportDate(event) {
    console.log(event, '报告日期')
    this.setData({
      reportDate: event.detail.value
    })
  },
  /**
   * 输入作业名称
   */
  inputWorkName(event) {
    console.log(event, '输入作业名称')
  },
  /**
   * 输入预定作业时间
   */
  pickReverseDate(event) {
    console.log(event)
    this.setData({
      reserveDate: event.detail.value
    })
  },
  /**
   * 输入作业内容
   */
  inputWorkContent(event) {
    console.log(event, 'work Content')
  },
  /**
   * 输入作业分析
   */
  inputWorkAnalysis(event) {
    console.log(event, 'work analysis')
  },
  /**
   * 企业安全主管意见
   */
  inputSecureSupervisorOpinion(event) {
    console.log(event, 'secure supervisor opinion')
  },
  /**
   * 输入安全措施
   */
  inputSecureMeasures(event) {
    console.log(event, 'heheh')
  },
  /**
   * 单位盖章
   */
  phoneUnit(event) {
    wx.chooseImage({
      success: (res) => {
        // this.data.rectFilePath = res.tempFilePaths[0]
        wx.getFileSystemManager().readFile({
          filePath: res.tempFilePaths[0], // 选择图片返回的相对路径
          encoding: 'base64', // 编码格式
          success: res1 => { // 成功的回调
            this.setData({
              unitNamePic: 'data:image/png;base64,' + res1.data
            })
          }
        })
      }
    })
  },
  /**
   * 企业安全主管意见及签字的日期选择
   */
  enterSecureSignDate(event) {
    console.log(event, 'hehehe')
    this.setData({
      secureSupervisorSignDate: event.detail.value
    })
  },
  /**
   * 企业主管意见及签字
   */
  enterSignDate(event) {
    console.log(event, 'xixixi')
    this.setData({
      supervisorSignDate: event.detail.value
    })
  }
})