// pages/meetingList/meetingList.js
const app = getApp();
Page({
  /**
   * 页面的初始数据
   */
  data: {
    selectdata:[],
    startTime:[]
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad(options) {
    console.log(options)
    this.setData({
      curRole: app.globalData.curRole,
      companyId:options.companyId
    })
    let params = {
      enId:options.companyId
    }
    wx.showLoading({
      title: '正在加载',
    })
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api1/morningMeeting/list',
      method: 'get',
      data: params,
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res)
        this.setData({
          selectdata:res.data,
          enId:options.companyId,
        })
      },
      complete: () => {
        wx.hideLoading()
      }
    })
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow() {
    wx.setNavigationBarTitle({
      title: '企业晨会列表'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage() {

  },
  // 新增
  addNewHD(event){
    
    wx.navigateTo({
      url: '/pages/mettingadd/mettingadd?companyId=' +this.data.companyId,
    })
  },
   // 编辑
   edit(event){
    var item = event.target.dataset.item;
    wx.navigateTo({
      url: '/pages/mettingaedit/mettingedit?params=' + JSON.stringify(item),
    })
   
  }
})