// pages/course/course.js
const app = getApp()
import * as echarts from '../ec-canvas/echarts'
let curIndex = 0
  /**
   * 初始化图表
   */
  function initChart(canvas, width, height, dpr){
    const chart  = echarts.init(canvas, null, {
      width: width,
      height: height,
      devicePixelRatio: dpr
    });
    canvas.setChart(chart)
    const option = {
      title: {
        text: app.globalData.currentCourse.coursehour[curIndex].speed,
        left: 'center',
        top: 'center'
      },
      color: ['#090D9C', '#F4F4F5'],
      series: [
        {
          type: 'pie',
          radius: ['48%', '70%'],
          avoidLabelOverlap: false,
          itemStyle: {
            borderRadius: 10,
            borderColor: '#fff',
            borderWidth: 2
          },
          labelLine: {
            show: false
          },
          data: [
            {
              value: parseInt(app.globalData.currentCourse.coursehour[curIndex].speed)
            },
            {
              value: parseInt(100 - app.globalData.currentCourse.coursehour[curIndex].speed)
            }
          ]
        }
      ]
    }
    curIndex++
    chart.setOption(option)
    return chart
  }

Page({

  /**
   * 页面的初始数据
   */
  data: {
    isShowVideo: true,
    curCourse: app.globalData.currentCourse.courseBriefIntroduction,
    curCoursePic: 'https://img0.baidu.com/it/u=2265254049,1802113800&fm=26&fmt=auto&gp=0.jpg',
    courseVideoSrc: 'http://39.102.232.151:8030/video/8.mp4',
    courseVideoPlay: 'data:image/png;base64,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',
    animationDisappear: {},
    courses: app.globalData.currentCourse.coursehour,
    ec: {
      onInit: initChart
    },
    curCourseHourIndex: 0
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      courseVideoSrc: app.globalData.currentCourse.coursehour ? (app.globalData.appBaseUrlV3 + '/online-training/' + app.globalData.currentCourse.coursehour[0].lessonFilePath.split('\\online-training\\')[1]): '',
      curCourse: app.globalData.currentCourse.courseBriefIntroduction,
      courses: app.globalData.currentCourse.coursehour
    })
    console.log(app.globalData.currentCourse.coursehour, 'app.globaldata.currentCourse.coursehour   app.globaldata.currentCourse.coursehour')
    const arr1 = app.globalData.currentCourse.coursehour.filter(item => {
      return item.lessonFilePath.indexOf(".pdf") > -1
    })
    if (arr1.length === app.globalData.currentCourse.coursehour.length) {
      this.setData({
        isShowVideo: false
      })
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '在线培训'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    this.videoCV = wx.createVideoContext('course')
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {
    console.log('onhide  is onhide?')
    curIndex = 0
  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {
    console.log('onUnload  is onUnload?')
    curIndex = 0
  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },

  /**
   * 点击播放
   */
  playvideo(event) {
    const repAnimation = wx.createAnimation({
      duration: 50,
      timingFunction: 'step-start'
    })
    this.repAnimation = repAnimation
    repAnimation.translateX('-100%').step()
    this.setData({
      animationDisappear: repAnimation.export(),
    })
    console.log(this.videoCV)
    this.videoCV.play()
  },
  /**
   * 观看时间更新
   */
  videoUpdate(event) {
    console.log(event.detail, '视频继续播放')
    if (event.detail.currentTime > 0) {
      if (this.timerUpdate) {
        clearTimeout(this.timerUpdate)
        this.timerUpdate = setTimeout(() => {
          console.log('条用了吗')
          const seconds = parseInt('' + event.detail.currentTime)
          let hour = parseInt('' + seconds / 3600)
          let minute = parseInt('' + (seconds - hour * 3600) / 60)
          let second = parseInt('' + (seconds - 3600 * hour - 60 * minute))
          if (hour < 10) {
            hour = '0' + hour
          }
          if (minute < 10) {
            minute = '0' + minute
          }
          if (second < 10) {
            second = '0' + second
          }
          wx.request({
            url: app.globalData.appBaseUrlV2 + '/api/onlineTrainingRecord',
            method: 'POST',
            header: {
              Authorization: app.globalData.Authorization
            },
            data: {
              lastTimePoint: hour + ':' + minute + ':' + second,
              lessonId: this.data.courses[this.data.curCourseHourIndex].id
            },
            success: (res) => {
              console.log(res , 'authoriazation111')
            },
            fail: (res1) => {
              console.log(res1, 'lessonId lessonId')
            }
          })
        },500)
      } else {
        this.timerUpdate = setTimeout(() => {
          wx.request({
            url: app.globalData.appBaseUrlV2 + '/api/onlineTrainingRecord',
            method: 'POST',
            header: {
              Authorization: app.globalData.Authorization
            },
            data: {
              lastTimePoint: '00:00:00',
              lessonId: this.data.courses[this.data.curCourseHourIndex].id
            },
            success: (res) => {
              console.log(res , 'authoriazation111')
            },
            fail: (res1) => {
              console.log(res1, 'lessonId lessonId')
            }
          })
        },1000)
      }
      // if (!this.timerUpdate) {
      //   console.log('进来了吗  发三大倒计时拉肯德基垮落法结束了大甲方撒凤林街道')
      //   this.timerUpdate = setTimeout(() => {
      //     wx.request({
      //       url: app.globalData.appBaseUrlV2 + '/api/onlineTrainingRecord',
      //       method: 'POST',
      //       header: {
      //         Authorization: app.globalData.Authorization
      //       },
      //       data: {
      //         lastTimePoint: '00:00:00',
      //         lessonId: this.data.courses[this.data.curCourseHourIndex].id
      //       },
      //       success: (res) => {
      //       },
      //       fail: () => {}
      //     })
      //   },1000)
      //   console.log(this.timerUpdate, 'this.timerUpdate this.timerUpdate')
      // }else {
      //   console.log('fjksladjflkjdsalkjflkjsdalkfjlkdsjalkfjlsdajlfj')
      //   clearTimeout(this.timerUpdate)
      //   this.timerUpdate = 0
      // }
    }
    // this.data.curCourseHourIndex
    
  },
  /**
   * 展示章节
   */
  showArticle(event) {
    // console.log(event.target.dataset.index, 'heheheh')
    console.log(this.data.courses, 'this.data.courses this.data.courses ')
    console.log(this.data.courses[event.currentTarget.dataset.index], 'this.data.courses[event.target.dataset.index]')
    if (this.data.courses[event.currentTarget.dataset.index].lessonFilePath.endsWith('.mp4')) {
      this.setData({
        courseVideoSrc: app.globalData.currentCourse.coursehour ? (app.globalData.appBaseUrlV3 + '/online-training/' + app.globalData.currentCourse.coursehour[event.currentTarget.dataset.index].lessonFilePath.split('\\online-training\\')[1]): '',
        curCourseHourIndex: event.currentTarget.dataset.index
      })
    }
    if (this.data.courses[event.currentTarget.dataset.index].lessonFilePath.endsWith('.pdf')) {
      wx.showLoading({
        title: '正在加载',
      })
      wx.downloadFile({
        url: app.globalData.appBaseUrlV3 + '/online-training/' + this.data.courses[event.currentTarget.dataset.index].lessonFilePath.split('\\online-training\\')[1],
        success: (res) => {
          console.log(res, 'realdownloadfile')
          // this.setData({})
          wx.openDocument({
            filePath: res.tempFilePath,
            showMenu: true,
            success: () => {
              wx.request({
                url: app.globalData.appBaseUrlV2 + '/api/onlineTrainingRecord',
                method: 'POST',
                header: {
                  Authorization: app.globalData.Authorization
                },
                data: {
                  lessonId: this.data.courses[event.currentTarget.dataset.index].id
                },
                success: (res) => {
                  console.log(res , 'authoriazation111')
                },
                fail: (res1) => {
                  console.log(res1, 'lessonId lessonId')
                }
              })
            }
          })
        },
        complete: () => {
          console.log('调用了吗 调用了吗')
          wx.hideLoading()
        },
        fail: () => {
          console.log('fail fail fail')
        }
      })
    }
    // if (this.data.courses[event.target.dataset.index].fileType === 'mp4' ||　this.data.courses[event.target.dataset.index].fileType　=== 'wmv') {
    //   this.setData({
    //     courseVideoSrc: this.data.courses[event.target.dataset.index].fileUrl
    //   })
    // }
  }
})