const app = getApp()

// pages/enterprise/enterprises.js
Page({

  /**
   * 页面的初始数据
   */
  data: {
    enterprises: [],
    inputEnterName: '',
    orienterprises: [],
    animationope: {},
    enternameUrl: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAATBJREFUWEdjZBhgwDjA9jMMPgf49b6vZ/j/v4GSkPn3/6/jllLRA8SYgRECMAcYKnC8IMYAdDXnH/yQoIoDcjwESbb/ybvfDBtOfWEYdQDVQgAUpKfv/ECJClMVDjAflzgoCv4zMOBMgIyMjAc2FQs2wgzFmQhBaYDaDmBkYHBgYGRsINoBpKZCQonQr+fd/1EHkBQCoCAlFSCXA7497/aD9G8uEXIE0SRHASxOkR0RYMYD5oIswiUOy4ZUccCzd39RLJISYgbzcYlTNQRIDX70XEBxCAx5B6B7gKxESE5RTNVEiC+10zwXDPk0MJoLKM4FlKaBoeMAcFMcGfz/32CsxPGe1BAAqT9774cgqMrFqhfU30CSA7WMwE0yanRGSHYstGk2+LpmJPuEQg0DHgIApKUsP22DHJIAAAAASUVORK5CYII=',
    enterImgUrl: 'http://39.102.232.151:8030/cover/企业搜索icon.png',
    animationSearch: {},
    curRole:''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(app.globalData,'隐患')
    this.setData({
      curRole: app.globalData.curRole
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.hideHomeButton({
      complete:()=>{
        console.log(99999)
      }
    })
    wx.setNavigationBarTitle({
      title: '企业列表'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    wx.showLoading({
      title: '正在获取企业信息',
    })
    // 验证获取企业信息
    wx.request({
      url: app.globalData.appBaseUrl + '/api/thHiddenDanger/pageEnterprise',
      method: 'GET',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        page: 0,
        size: 99999,
        enterpriseName: '威海',
        county:app.globalData.appCounty
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        if (res.statusCode === 200) {
          console.log(res.data.content)
          this.setData({
            enterprises: [...res.data.content]
          })
        } else if (res.statusCode === 401) {
          wx.redirectTo({
            url: '/pages/login/login',
          })
        } else {

        }
        wx.hideLoading()
      },
      fail: () => {
        wx.hideLoading()
      }
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {
    // this.animate1.top('50%').scale(0.9).step()
    // this.animate2.opacity(0).step()
    // this.setData({
    //   animationsearch: this.animate1.export(),
    //   animationlist: this.animate2.export()
    // })
  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  /**
   * 输入企业信息
   */
  enterNameInput(event) {
    this.inputEnterName = event.detail.value
  },
  /**
   * 触摸面板 搜索企业信息
   */
  enterNameConfirm(event) {
    wx.showLoading({
      title: '正在获取企业信息',
    })
    // 验证获取企业信息
    wx.request({
      url: app.globalData.appBaseUrl + '/api/thCompany',
      method: 'GET',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        page: 0,
        size: 99999,
        companyName: this.inputEnterName,
        sort: 'companyId,desc',
        companyCounty:app.globalData.appCounty,
      
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        if (res.statusCode === 200) {
          this.setData({
            enterprises: [...res.data.content]
          })
        } else if (res.statusCode === 401) {
          wx.redirectTo({
            url: '/pages/login/login',
          })
        } else {

        }
        wx.hideLoading()
      },
      fail: () => {
        wx.hideLoading()
      }
    })
  },
  focusInputName(event) {
    let repheight = 0
    wx.getSystemInfoAsync({
      success: (result) => {
        repheight = result.windowHeight
      },
    })
    this.repheight = repheight
    console.log(this.repheight, 'this.repheight')
    // animationsearch
    //animationlist
    const repAnimation = wx.createAnimation({
      duration: 40,
      timingFunction: 'linear'
    })
    this.animate1 = repAnimation
    // repAnimation.translateY(-repheight/2 + 'px').scale(1).step()
    repAnimation.top(0).scale(1.0).step()
    this.setData({
      animationsearch: repAnimation.export()
    })
    const tempAnimation = wx.createAnimation({
      durartion: 400,
      timingFunction: 'linear'
    })
    this.animate2 = tempAnimation
    tempAnimation.opacity(1).step()
    this.setData({
      animationlist: tempAnimation.export()
    })
  },
  blurInputName(event) {
  },
  /**
   * 隐患管理
   */
  dgregister(event) {
    // app.globalData.currentEnter.index = event.target.dataset.index
    // wx.navigateTo({
    //   url: '/pages/dangerregister/dangerregister',
    //   success: function(event) {
    //   }
    // })
    // app.globalData.currentEnter = {...this.enterprises[event.target.dataset.index]}
    console.log(event.target.dataset.index, 'sssssssssssss')
    app.globalData.currentEnter = {... this.data.enterprises[event.target.dataset.index]}
    wx.navigateTo({
      url: '/pages/dangerlist/dangerlist',
      success: function(event) {
      }
    })
  },
  /**
   * 风险管理
   */
  dgrisk: function(event) {
  },
  /**
   * 企业触摸触发
   */
  comTouchStart(event) {
    this.curComIndex = event.target.dataset.index
    this.timestart = new Date().getMilliseconds()
  },
  comTap(event) {
    if (this.curComIndex === event.target.dataset.index) {
      console.log('这里执行了吗');
      this.timeend = new Date().getMilliseconds()
      console.log(this.timeend)
      console.log(this.timestart)
      if (this.timeend - this.timestart > 50) {
        console.log('这里执行了吗');

      }
    }
  },
  /**
   * 触摸离开
   */
  comTouchEnd(event) {
    console.log(event, 'ehehehhe')
    if (this.curComIndex === event.target.dataset.index) {
      console.log('这里执行了吗');
      this.timeend = new Date().getMilliseconds()
      console.log(this.timeend)
      console.log(this.timestart)
      if (Math.abs(this.timeend - this.timestart) > 300) {
        console.log('这里执行了吗');
        const repAnimation = wx.createAnimation({
          duration: 400,
          timingFunction: 'linear'
        })
        this.tempAnimate = repAnimation
        repAnimation.translateY('0rpx').step()
        this.setData({
          animationope: repAnimation.export()
        })
      }
    }
  },
  comLongTouch(event) {
    this.curComIndex = event.target.dataset.index
    const repAnimation = wx.createAnimation({
      duration: 200,
      timingFunction: 'linear'
    })
    this.tempAnimate = repAnimation
    repAnimation.translateY('0rpx').step()
    this.setData({
      animationope: repAnimation.export()
    })
  },
  removeanimate() {
    this.tempAnimate.translateY('100%').step()
    this.setData({
      animationope: this.tempAnimate.export()
    })
  },
  searchInputFocus(event) {
    const repAnimation = wx.createAnimation({
      duration: 50,
      timingFunction: 'step-start'
    })
    this.repAnimation = repAnimation
    repAnimation.width('100%').step()
    this.setData({
      animationSearch: repAnimation.export()
    })
  }
})