// app.js
App({
  onLaunch() {
    // 展示本地存储能力
    const logs = wx.getStorageSync('logs') || []
    logs.unshift(Date.now())
    wx.setStorageSync('logs', logs)
    if (wx.canIUse('getUpdateManager')) {
      const updateManager = wx.getUpdateManager()
      updateManager.onCheckForUpdate(function (res) {
        console.log('onCheckForUpdate====', res)
        // 请求完新版本信息的回调
        if (res.hasUpdate) {
          console.log('res.hasUpdate====')
          updateManager.onUpdateReady(function() {
            wx.showModal({
              title: '更新提示',
              content: '新版本已经准备好, 是否重启应用?',
              success: function(res) {
                console.log('success====', res)
                if (res.confirm) {
                  // 新的版本已经下载好, 调用 applyUpdate 应用新版本重启
                  updateManager.applyUpdate()
                }
              }
            })
          })
          updateManager.onUpadateFailed(function() {
            // 新的版本下载失败
            wx.showModal({
              title: '已经有新版本了',
              content: '新版本已经上线, 请您删除当前小程序, 重新搜索打开'
            })
          })
        }
      })
    }
    // 登录
    // wx.login({
    //   success: res => {
    //     // 发送 res.code 到后台换取 openId, sessionKey, unionId
    //   }
    // })
  },
  globalData: {
    // appCounty:'荣成市',//全局区域设定
    // appBaseUrlAll:'http://192.168.3.37:8035',
    // appBaseUrl: 'http://192.168.3.37:8035',
    // appBaseUrlV2: 'http://192.168.3.37:8035',
    // appBaseUrlV3: 'http://192.168.3.37:8035',


    appCounty:'威海经济技术开发区',//全局区域设定
    appBaseUrlAll:'https://whjqaqscxt.weihai.cn',
    appBaseUrl: 'https://whjqaqscxt.weihai.cn',
    appBaseUrlV2: 'https://whjqaqscxt.weihai.cn',
    appBaseUrlV3: 'https://whjqaqscxt.weihai.cn',
    appBaseUrlArea: 'https://www.tianhongzhijian.com:8888',
 
    userInfo: null,
    Authorization: '',
    curRole: '', // 运营商 企业管理 企业员工 政府  超级管理员 
    companyId: -1,
    companyName: '',
    currentEnter: {}, 
    currentHD: {},
    currentLawItem: {},
    currentAdviceItem: {},
    currentCourse: {},
    currentTrainImg: {},
    curEvaluate: {},
    testPaperId: -1,
    singleScore: 0,
    multiScore: 0,
    justifyScore: 0,
    isNeedNavigateTo: false
  }
})
