// pages/certifyEnter/certifyenter.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    enterSearchImgUrl: 'http://39.102.232.151:8030/cover/企业搜索icon.png',
    certifyenterImgUrl: 'http://39.102.232.151:8030/cover/证书企业icon.png',
    enters: [
    ],
    curRole: '',
    companyName: '',
    emergency: 0,
    dualSystem: 0,
    standardization: 0
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    // 根据 curRole 进行请求
    // this.data.curRole = app.globalData.curRole
    this.setData({
      curRole: app.globalData.curRole
    })
    console.log(this.data.curRole, 'this.data.curRole')
    if (this.data.curRole === '政府') {
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/pageEnterprise',
        method: 'get',
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          console.log(res,'resseeeeee')
          this.setData({
            enters: [...res.data.content.map(item => {
              return {
                companyName: item.enterpriseName,
                companyId: item.enterpriseId,
                emergencyPlan: item.emergencyPlanNum,
                dualSystem: item.dualSystemNum,
                standardization: item.standardizationNum,
                resListNum: item.resListNum
              }
            })]
          })
        }
      })
    } else if (this.data.curRole === '运营商') {
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/pageEnterprise',
        method: 'get',
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          this.setData({
            enters: [...res.data.content.map(item => {
              return {
                companyName: item.enterpriseName,
                companyId: item.enterpriseId,
                emergencyPlan: item.emergencyPlanNum,
                dualSystem: item.dualSystemNum,
                standardization: item.standardizationNum,
                 resListNum: item.resListNum
              }
            })]
          })
        }
      })
    } else if (this.data.curRole === '企业管理') {
      wx.request({
        url: app.globalData.appBaseUrl + '/api/thCompany/query',
        method: 'get',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: app.globalData.companyId
        },
        success: (res) =>{
          console.log(res.data, 'thCompany/query')
          if (res.data && res.data.length > 0) {
            console.log(this.data, 'this.data')
            this.setData({
              companyName: res.data[0].companyName
            })
            wx.request({
              url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/pageEnterprise',
              method: 'get',
              header: {
                Authorization: app.globalData.Authorization
              },
              data: {
                companyName: res.data[0].companyName
              },
              success: (res1)=> {
                console.log(res1, 'api1/enterpriseCertificate/pageEnterprise')
                this.setData({
                  enters: [...res1.data.content.map(item => {
                    return {
                      companyName: item.enterpriseName,
                      companyId: item.enterpriseId,
                      emergencyPlan: item.emergencyPlanNum,
                      dualSystem: item.dualSystemNum,
                      standardization: item.standardizationNum,
                       resListNum: item.resListNum
                    }
                  })]
                })
              }
            })
          }
        }
      })
      // wx.request({
      //   url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
      //   method: 'GET',
      //   data: {
      //     companyId: app.globalData.companyId,
      //     category: '双体系证书'
      //   },
      //   header: {
      //     Authorization: app.globalData.Authorization
      //   },
      //   success(res) {
      //     console.log(res.data, '双体系证书, enterpriseCertificate/page')
      //     this.setData({
      //       dualSystem: res.data.content.length
      //     })
      //   }
      // })
      // wx.request({
      //   url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
      //   method: 'GET',
      //   data: {
      //     companyId: app.globalData.companyId,
      //     category: '应急预案'
      //   },
      //   header: {
      //     Authorization: app.globalData.Authorization
      //   },
      //   success(res) {
      //     console.log(res.data, '应急预案, enterpriseCertificate/page')
      //     this.setData({
      //       emergency: res.data.content.length
      //     })
      //   }
      // })
      // wx.request({
      //   url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
      //   method: 'GET',
      //   data: {
      //     companyId: app.globalData.companyId,
      //     category: '应急预案'
      //   },
      //   header: {
      //     Authorization: app.globalData.Authorization
      //   },
      //   success(res) {
      //     console.log(res.data, '应急预案, enterpriseCertificate/page')
      //     this.setData({
      //       emergency: res.data.content.length
      //     })
      //   }
      // })
    } else if (this.data.curRole === '超级管理员') {
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/pageEnterprise',
        method: 'get',
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          console.log(res,'resssssss')
          this.setData({
            enters: [...res.data.content.map(item => {
              return {
                companyName: item.enterpriseName,
                companyId: item.enterpriseId,
                emergencyPlan: item.emergencyPlanNum,
                dualSystem: item.dualSystemNum,
                standardization: item.standardizationNum,
                 resListNum: item.resListNum
              }
            })]
          })
        }
      })
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {
    
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: "企业安全档案",
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff'
    })
   
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },

  /**
   * 跳转到应急预案
   */
  tapToEmergency(event) {
    console.log(event, 'tapToEmergency')
    wx.navigateTo({
      url: '/pages/certify/certify?type=1&companyId='+event.currentTarget.dataset.index.companyId,
    })
  },
  /**
   * 跳转到双体系
   */
  tapToDualSystem(event) {
    console.log(event, 'tapToDualSystem')
    wx.navigateTo({
      url: '/pages/certify/certify?type=2&companyId='+event.currentTarget.dataset.index.companyId,
    })
  },
  /**
   * 跳转到标准化
   */
  tapToStandardization(event) {
    console.log(event, 'tapToStandardization')
    wx.navigateTo({
      url: '/pages/certify/certify?type=3&companyId='+event.currentTarget.dataset.index.companyId,
    })
  },
   /**
   * 跳转到责任清单
   */
  tapToQ(event) {
    console.log(event, 'tapToQ')
    wx.navigateTo({
      url: '/pages/certify/certify?type=4&companyId='+event.currentTarget.dataset.index.companyId,
    })
  },
  /**
   * 搜索企业
   */
  searchEnters(event) {
    console.log(event.detail.value, 'searchEnters')
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/pageEnterprise',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        enterpriseName: event.detail.value
      },
      success: (res) => {
        this.setData({
          enters: [...res.data.content.map(item => {
            return {
              companyName: item.enterpriseName,
              companyId: item.enterpriseId,
              emergencyPlan: item.emergencyPlanNum,
              dualSystem: item.dualSystemNum,
              standardization: item.standardizationNum
            }
          })]
        })
      }
    })
  }
})