// pages/exam/exam.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    searchIcon: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB8AAAAeCAYAAADU8sWcAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyFpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQyIDc5LjE2MDkyNCwgMjAxNy8wNy8xMy0wMTowNjozOSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo3OUEyMURGNjE1M0IxMUVDQTdBRjk3NTlCRkY2MTk5QSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo3OUEyMURGNzE1M0IxMUVDQTdBRjk3NTlCRkY2MTk5QSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjc5QTIxREY0MTUzQjExRUNBN0FGOTc1OUJGRjYxOTlBIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjc5QTIxREY1MTUzQjExRUNBN0FGOTc1OUJGRjYxOTlBIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+4+94kQAAAydJREFUeNq8l2tozXEYx885Y4whG5l70lBjm8vcX4iySBpKUW7thcILvNCWXDMrXpGEvOCVkrTSmJI7Iy/mEsXI3Vgzu5TbtjOfR99z+jnOzs7sHE99Or/zP//z/z6/5/f7Pc/z9xYUFHiisNEwHjJhOPSFLvADPsFzqIBHUFVcXNwazUO97YhPgcUwDXo4139CCyRCgnP9A1yFM/C2PSfaEk+G9ZAHXeE73INyeAGfoRm6QxpkwEwYY8+EGjgGJTjg74j4UNgJWdAE5+C0QvuX8fDfn4WFhRaBGbAcJsqJU3CYe76F+68vjPA+Cb+BLfb8toRDnGiB6ww3wiFFZhlslmMRxZNgG6RDJWyCGxDV5nGc+A4nGe5S5BZBfjgHXPF87ehq2AqvPZ0wHLjAx345sMqWAgd84cRHwVKND8JLT2ysBMqgG6zUBv1D3DbGQh2lW3Cxo6GOMHvb6cehAaZCtjt7GwyA6fp+NlbCjgPvNXuzOZpsUDwbhsE7uOuJj11SUsrRxg6KZ2j8UJkrHvZKaXiQQei9AfHBzg3xMsuQVRqnBULvUyo1q4ujuB23Rid1B8MeyL0JcRT3Os/3u+KBGfeLo7iV3z6hEfY5mSw9juK91Ac0qey2BsQrdNGKSUqcxDPlgBWo6kCdN/En8FRhme0mgRjafGmVa6LBsFvqu6zvS9zdGAvjTE9WJ/RVOv7QwlJqbQ+MhBWxmj3CvflYqw1nKbbSba0C4tYWHdXYqs/czjqgArIBxoHl9xPurEPreZnangTV83n/6gDCSeqC8qRxAD6GNpShbdQRLYH9eTusc85ntMLWGxSp6/U51Sw53OF3zTbFHqhXI7gGZqmBvAa16s1CBa1JGAIL1Db1VCEpVQRzraHgvt3MviGavt3WfbWSj4X/C9xXl1OjCmgNyEC9VGQ5KfSKtc4IVSI4ifFe5ZDb1idyvT6al4YUnf1c1f1Ie6BR5/g83EGg2YnMBC1Ff3VLO/i9zhvl61Ki0uNYGAGpzuuSlcpn8FjZy9/GXsjRkqbKgaJoxSO1SR3ZjFlaAmvdbvo8/9Fw9IH5oBxf+0uAAQADzexIIUoooQAAAABJRU5ErkJggg==',
    animationSearch: {},
    examList: [
      {
        coverPic: 'http://39.102.232.151:8030/cover/exam1.jpg',
        examName: '安全内容考试（一）',
        isExamed: true,
        score: 80
      },
      {
        coverPic: 'http://39.102.232.151:8030/cover/exam2.jpg',
        examName: '安全内容考试（二）',
        isExamed: false,
        score: 0
      }
    ]
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api1/onlineExamPaper/page',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        page: 0,
        size: 999,
        county:app.globalData.appCounty
      },
      success: (res) => {
        if (res.statusCode === 200) {
          console.log(res.data.content, 'res.data.content res.data.content')
          res.data.content.forEach(item => {
            if(!item.score) {
              item.isExamed = false
              item.score = 0
            } else {
              item.isExamed = true
            }
          })
          this.setData({
            examList: res.data.content
          })
        }
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成 
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '在线考试'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    if (app.globalData.isNeedNavigateTo) {
      app.globalData.isNeedNavigateTo = false
      wx.navigateTo({
        url: '/pages/testpaper/testpaper?id=' + app.globalData.testPaperId +'&singleScore=' + app.globalData.singleScore + '&multiScore=' + app.globalData.multiScore + '&justifyScore=' + app.globalData.justifyScore,
        success: function(event) {}
      })
    }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  /**
   * 搜索框focus
   */
  searchFocus(event) {
    const repAnimation = wx.createAnimation({
      duration: 50,
      timingFunction: 'step-start'
    })
    this.repAnimation = repAnimation
    repAnimation.translateX('0rpx').width('100%').step()
    this.setData({
      animationSearch: repAnimation.export()
    })
  },
  /**
   * 跳转到考试试题
   */
  LinkToTestPaper(event) {
    wx.navigateTo({
      url: '/pages/testpaper/testpaper?id=' + event.currentTarget.dataset.index.id +'&singleScore=' + event.currentTarget.dataset.index.singleChoiceScore + '&multiScore=' + event.currentTarget.dataset.index.multipleChoiceScore + '&justifyScore=' + event.currentTarget.dataset.index.judgmentScore,
      success: function(event) {}
    })
  },
  /**
   * 搜索考试内容
   */
  searchExam(event) {
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/onlineExamPaper/page',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        page: 0,
        size: 999,
        name: event.detail.value
      },
      success: (res) => {
        if (res.statusCode === 200) {
          console.log(res.data.content, 'res.data.content res.data.content')
          res.data.content.forEach(item => {
            if(!item.score) {
              item.isExamed = false
              item.score = 0
            } else {
              item.isExamed = true
            }
          })
          this.setData({
            examList: res.data.content
          })
        }
      }
    })
  }
})