// pages/info/info.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    num:null,
    infoList: [
    ]
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/infoPush/page',
      header: {
        Authorization: app.globalData.Authorization
      },
      method: 'get',
      data: {
        county:app.globalData.appCounty,
        page: 0,
        size: 999
      },
      success: (res) => {
        console.log(res, 'info 推送')
        this.setData({
          num:res.data.content.length,
          infoList: res.data.content.map(item => {
            return {
              title: item.content,
              isRead: false,
              time: item.createTime,
               
            }
          })
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '信息推送'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })


  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})