// pages/law/law.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    lawList: [
    ],
    curPage: 0,
    curPageSize: 99999,
    isPullDown: false
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options)
    if(options.id){
      let category_id=options.id
      wx.showLoading({
        title: '正在加载',
      })
      wx.request({
        url: app.globalData.appBaseUrlV2+ '/api/thLaw',
        // url: app.globalData.appBaseUrlV2+ '/api1/thLaw/queryAll',
        header: {
          Authorization: app.globalData.Authorization
        },
        method: 'GET',
        data: {
          category_id,
          county:app.globalData.appCounty,
          page: this.data.curPage,
          size: this.data.curPageSize,
          // sort: 'law_date,desc'
        },
        success: (res) => {
          console.log(res, 'wx.request')
          this.setData({
            lawList: res.data.content
          })
        },
        fail: (res) => {},
        complete: () => {
          wx.hideLoading()
        }
      })
    }else{
      let category_pid=options.pid
      wx.showLoading({
        title: '正在加载',
      })
      wx.request({
        url: app.globalData.appBaseUrlV2+ '/api/thLaw',
        // url: app.globalData.appBaseUrlV2+ '/api1/thLaw/queryAll',
        header: {
          Authorization: app.globalData.Authorization
        },
        method: 'GET',
        data: {
          category_pid,
          county:app.globalData.appCounty,
          page: this.data.curPage,
          size: this.data.curPageSize,
          // sort: 'law_date,desc'
        },
        success: (res) => {
          console.log(res, 'wx.request')
          this.setData({
            lawList: res.data.content
          })
        },
        fail: (res) => {},
        complete: () => {
          wx.hideLoading()
        }
      })
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '法律法规'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  /**
   * 
   */
  pullDownRefresh() {
    // this.isPullDown = false
    // console.log(this.data.isPullDown)
    // this.setData({
    //   isPullDown: false
    // })
    /**
     * 
     */
    // setTimeout(() => {
    //   this.setData({
    //     isPullDown: false
    //   })
    // }, 2000)
    this.data.curPageSize += 10
    wx.request({
      url: app.globalData.appBaseUrlV2+ '/api/thLaw/queryAll',
      header: {
        Authorization: app.globalData.Authorization
      },
      method: 'GET',
      data: {
        county:app.globalData.appCounty,
        page: this.data.curPage,
        size: this.data.curPageSize,
        sort: 'lawDate,desc'
      },
      success: (res) => {
        console.log(res, 'wx.request')
        this.setData({
          lawList: res.data.content,
          isPullDown: false
        })
      },
      fail: (res) => {},
      complete: () => {
      }
    })
  },
  /**
   * 跳转到法律详情
   */
  clickToLawItem(event) {
    console.log(event.target.dataset.index, 'index')
    app.globalData.currentLawItem = this.data.lawList[event.target.dataset.index]
    this.data.lawList[event.target.dataset.index].currentUserRead = true
    this.setData({
      lawList: this.data.lawList
    })
    console.log(this.data.lawList[event.target.dataset.index], 'this.data.lawList[event.target.dataset.index]')
    wx.navigateTo({
      url: '/pages/lawItem/lawItem',
      success: (res) => {
        res.eventChannel.emit('acceptDataFromOpenerPage', { lawId: this.data.lawList[event.target.dataset.index].lawId })
      }
    })
  }
})