// pages/mettingadd/mettingadd.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    // 图片
    imgs: [],
    // 晨会时间
    mettingDate: '',
    // 晨会内容
    content:'',
     // 应参加人数
    person:'',
     // 实际参加人数
    tactualperson:'',
    //晨会照片
    // imgsrcurl: '',
    // 上传时间
    upload:'',
    companyId:'',
    baseImg: [], // base64图片集合
    maxImg: 9, // 图片上传最高数量（根据需求设置）
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad(options) {
    console.log(options)
    this.setData({
      curRole: app.globalData.curRole,
      companyId:options.companyId
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow() {
    wx.setNavigationBarTitle({
      title: '企业晨会新增',
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage() {

  },
  // 选择晨会时间
  selectMettingDate(event) {
    this.setData({
      mettingDate: event.detail.value
    })
  },
   //晨会内容
   inputContent(event) {
     console.log(event,'626256')
    this.data.content = event.detail.value
  },
  // 应参加人数
  inputPerson(event) {
    this.data.person = event.detail.value
  },
   // 实际参加人数
   inpuTactualperson(event) {
    this.data.tactualperson = event.detail.value
  },
    // 上传图片
    chooseImg: function (e) {
      var that = this;
      var imgs = this.data.imgs;
      if (imgs.length >= 9) {
       this.setData({
        lenMore: 1
       });
       setTimeout(function () {
        that.setData({
         lenMore: 0
        });
       }, 2500);
       return false;
      }
      wx.chooseImage({
       // count: 1, // 默认9
       sizeType: ['original', 'compressed'], 
       sourceType: ['album', 'camera'], 
       success: function (res) {
        // 返回选定照片的本地文件路径列表，tempFilePath可以作为img标签的src属性显示图片
        var tempFilePaths = res.tempFilePaths;
        console.log(tempFilePaths);
        for(var str of tempFilePaths){
          wx.getFileSystemManager().readFile({
            filePath: str, // 选择图片返回的相对路径
            encoding: 'base64', //编码格式
            success: res1 => { // 成功的回调
              console.log(res1)
              var baseimg = 'data:image/png;base64,' + res1.data;
              var imgs = that.data.imgs;
              imgs.push(baseimg);
              that.setData({
                imgs: imgs
              });
              console.log(imgs);
            }
          })
        }
        return;
       }
      });
     },
     // 删除图片
     deleteImg: function (e) {
      var imgs = this.data.imgs;
      var index = e.currentTarget.dataset.index;
      imgs.splice(index, 1);
      this.setData({
       imgs: imgs
      });
     },
     // 预览图片
     previewImg: function (e) {
       //获取当前图片的下标
      var index = e.currentTarget.dataset.index;
       //所有图片
      var imgs = this.data.imgs;
      wx.previewImage({
       //当前显示图片
       current: imgs[index],
       //所有图片
       urls: imgs
      })
     },
   // 上传时间
   uploadTime(event) {
    this.setData({
      upload: event.detail.value
    })
  },
  // 上传
  submit(){
    if(this.data.mettingDate==''){
      wx.showToast({
        title: '选择晨会时间',
        icon: 'error',
      })
      return
      }
   
    if(this.data.content==''){
      wx.showToast({
        title: '输入晨会内容',
        icon: 'error',
      })
      return
    }
    if(this.data.person==''){
      wx.showToast({
        title: '输入应参加人数',
        icon: 'error',
      })
      return
    }
    if(this.data.tactualperson==''){
      wx.showToast({
        title: '输入实际参加人数',
        icon: 'error',
      })
      return
    }
    if(this.data.imgs==''){
      wx.showToast({
        title: '选择晨会照片',
        icon: 'error',
      })
      return
    }
    if(this.data.upload==''){
      wx.showToast({
        title: '选择上传时间',
        icon: 'error',
      })
      return
    }
  
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api1/morningMeeting' ,
      method: 'POST',
      data: {
        actualPeople:this.data.tactualperson,//实际参加人数
        meetingTime: this.data.mettingDate,//晨会时间
        shouldPeople:this.data.person,//应参加人数
        uploadTime:this.data.upload,//上传时间
        content:this.data.content,//晨会内容
        companyId:this.data.companyId,//id
        pic:this.data.imgs//图片
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        console.log(res)
        if (res.statusCode === 201) {
          wx.showToast({
            title: '提交成功',
            icon:'success',
            duration: 1000
          })
          wx.redirectTo({
            url: '/pages/meeting/meeting',
          })
        } else if (res.statusCode === 400) {
          wx.showToast({
            title: '提交失败！',
            icon: 'error',
          })
        }
    }
  }) 
  }
})