// pages/certify/certify.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    certifySerchIcon: 'http://39.102.232.151:8030/cover/企业搜索icon.png',
    certifyList: [
    ],
    curRole: '',
    isShowImg: false,
    showImgSrc: '',
    companyId: -1,
    type: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      curRole: app.globalData.curRole
    })
    this.data.companyId = options.companyId
    this.data.type = options.type
    console.log(options, 'onloadOption in certify')
    if (this.data.type === '1') {
      //应急预案
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '应急预案'
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    } else if (this.data.type === '2') {
      // 双体系
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '双体系证书'
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    } else if (this.data.type === '3') {
      // 标准化
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '标准化'
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    }else if (this.data.type === '4') {
      // 责任清单
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '责任清单'
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '企业安全档案'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    if (this.data.type === '1') {
      //应急预案
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '应急预案'
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    } else if (this.data.type === '2') {
      // 双体系
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '双体系证书'
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    } else if (this.data.type === '3') {
      // 标准化
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '标准化'
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  navigateToCertify() {
    wx.navigateTo({
      url: '/pages/certifyitem /certifyitem',
      success: function(event) {}
    })
  },
  pullDownRefresh() {
    console.log('pullDownRefresh pullDownRefresh pullDOwnRefresh')
    setTimeout(() => {
      this.setData({
        isPullDown: false
      })
    }, 500)
  },
  addEnterpriseCertify() {
    wx.navigateTo({
      url: '/pages/addcertify/addcertify',
    })
  },
  viewFile(event) {
    console.log(event, 'viewFile viewFile')
    console.log(event.currentTarget.dataset.index, 'event.target.dataset.index')
    const tofilePath = this.data.certifyList[event.target.dataset.index].filepath
    const index1 = tofilePath.indexOf('\\ht')
    console.log(index1)
    const index2 = tofilePath.indexOf('\\', index1 + 1)
    // const index3 = tofilePath.indexOf('\\', index2 + 1)
    const resultFilePath = tofilePath.substr(index2)
    console.log(app.globalData.appBaseUrlV3 + resultFilePath, 'resultFilePath')
    if (!resultFilePath.endsWith('.pdf')) {
      wx.previewImage({
        urls: [app.globalData.appBaseUrlV3 + resultFilePath],
      })
    } else {
      wx.showLoading({
        title: '正在加载',
      })
      wx.downloadFile({
        url: app.globalData.appBaseUrlV3 + resultFilePath,
        success: (res) => {
          console.log(res, 'realdownloadfile')
          if (res.tempFilePath.endsWith('.pdf')) {
            // this.setData({})
            wx.openDocument({
              filePath: res.tempFilePath,
              showMenu: true
            })
          } else {
            // this.setData({
            //   isShowImg: true,
            //   showImgSrc: res.tempFilePath
            // })
            // wx.previewImage({
            //   urls: [res.tempFilePath],
            // })
          }
          
        },
        complete: () => {
          console.log('调用了吗 调用了吗')
          wx.hideLoading()
        },
        fail: () => {
          console.log('fail fail fail')
        }
      })
    }
  },
  viewCertify(event) {
    // console.log(event, 'viewFile viewFile')
    // console.log(event.currentTarget.dataset.index, 'event.target.dataset.index')
    const tofilePath = this.data.certifyList[event.target.dataset.index].filepath
    const index1 = tofilePath.indexOf('\ht')
    const index2 = tofilePath.indexOf('\\', index1 + 1)
    // const index3 = tofilePath.indexOf('\\', index2 + 1)
    const resultFilePath = tofilePath.substr(index2)
    // const resultFilePath = tofilePath.substr(index3)
    // console.log(app.globalData.appBaseUrlV3 + resultFilePath, 'resultFilePath')
    
    if (!resultFilePath.endsWith('.pdf')) {
      // wx.showLoading({
      //   title: '正在加载',
      // })
      wx.previewImage({
        urls: [app.globalData.appBaseUrlV3 + resultFilePath],
      })
    } else {
      // wx.showLoading({
      //   title: '正在加载',
      // })
      wx.downloadFile({
        url: app.globalData.appBaseUrlV3 + resultFilePath,
        success: (res) => {
          console.log(res, 'realdownloadfile')
          if (res.tempFilePath.endsWith('.pdf')) {
            // this.setData({})
            wx.openDocument({
              filePath: res.tempFilePath,
              showMenu: true
            })
          } else {
            // this.setData({
            //   isShowImg: true,
            //   showImgSrc: res.tempFilePath
            // })
            wx.previewImage({
              urls: [res.tempFilePath],
            })
          }
          
        },
        complete: () => {
          console.log('调用了吗 调用了吗')
          // wx.hideLoading()
        },
        fail: () => {
          console.log('fail fail fail')
        }
      })
    }
  },
  deleteCertify(event) {
    wx.showModal({
      title: '提示',
      content: '是否删除所选项',
      success: (res) => {
        if (res.confirm) {
          wx.showLoading({
            title: '正在删除',
          })
          wx.request({
            url: app.globalData.appBaseUrlV2 + '/api/enterpriseCertificate',
            method: 'DELETE',
            data: [this.data.certifyList[event.target.dataset.index].id],
            header: {
              Authorization: app.globalData.Authorization
            },
            success: (resd) => {
              console.log(resd, 'enterpriseCertificate delete')
              if (resd.statusCode === 204) {
                wx.showToast({
                  title: '删除成功',
                })
                if (this.data.type === '1') {
                  //应急预案
                  wx.request({
                    url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
                    method: 'GET',
                    header: {
                      Authorization: app.globalData.Authorization
                    },
                    data: {
                      companyId: this.data.companyId,
                      category: '应急预案'
                    },
                    success: (res) => {
                      console.log(res, 'api/enterpriseCertificate/page')
                      this.setData({
                        certifyList: [...res.data.content.map(item => {
                          return {
                            type: item.category,
                            name: item.name,
                            uploadDate: item.uploadDate,
                            validDate: item.expirationDate,
                            id: item.id,
                            filepath: item.filePath
                          }
                        })]
                      })
                    }
                  })
                } else if (this.data.type === '2') {
                  // 双体系
                  wx.request({
                    url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
                    method: 'GET',
                    header: {
                      Authorization: app.globalData.Authorization
                    },
                    data: {
                      companyId: this.data.companyId,
                      category: '双体系证书'
                    },
                    success: (res) => {
                      console.log(res, 'api/enterpriseCertificate/page')
                      this.setData({
                        certifyList: [...res.data.content.map(item => {
                          return {
                            type: item.category,
                            name: item.name,
                            uploadDate: item.uploadDate,
                            validDate: item.expirationDate,
                            id: item.id,
                            filepath: item.filePath
                          }
                        })]
                      })
                    }
                  })
                } else if (this.data.type === '3') {
                  // 标准化
                  wx.request({
                    url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
                    method: 'GET',
                    header: {
                      Authorization: app.globalData.Authorization
                    },
                    data: {
                      companyId: this.data.companyId,
                      category: '标准化'
                    },
                    success: (res) => {
                      console.log(res, 'api/enterpriseCertificate/page')
                      this.setData({
                        certifyList: [...res.data.content.map(item => {
                          return {
                            type: item.category,
                            name: item.name,
                            uploadDate: item.uploadDate,
                            validDate: item.expirationDate,
                            id: item.id,
                            filepath: item.filePath
                          }
                        })]
                      })
                    }
                  })
                }
              }
            },
            complete: () => {
              wx.hideLoading()
            }
          })
        }
      }
    })
    //this.data.certifyList[event.target.dataset.index]
  },
  download(event) {
    const tofilePath = this.data.certifyList[event.target.dataset.index].filepath
    const index1 = tofilePath.indexOf('\\ht')
    const index2 = tofilePath.indexOf('\\', index1 + 1)
    // const index3 = tofilePath.indexOf('\\', index2 + 1)
    // const index4 = tofilePath.indexOf('\\', index3 + 1)
    const picFilePath = tofilePath.substr(index2 + 1)
    const index5 = picFilePath.indexOf('.')
    const picFilePath2 = picFilePath.substr(index5)
    const resultFilePath = tofilePath.substr(index2)
    console.log(app.globalData.appBaseUrlV3 + resultFilePath, 'resultFilePath')
    wx.showLoading({
      title: '正在加载',
    })
    console.log(picFilePath, 'picFilePath picFilePath')
    console.log(picFilePath2, 'picFilePath2 picFilePath2')
    console.log(`${wx.env.USER_DATA_PATH}`)
    const myPath = new Date().getTime() + picFilePath2
    const myPath2 = `${wx.env.USER_DATA_PATH}/${myPath}`
    wx.downloadFile({
      url: app.globalData.appBaseUrlV3 + resultFilePath,
      filePath: myPath2,
      success: (res) => {
        console.log(res, 'realdownloadfile')
        wx.showToast({
          title: '下载成功',
          icon: 'success',
          duration: 1500
        })
        wx.hideLoading()
        // wx.saveFile({
        //   tempFilePath: res.tempFilePath,
        //   success: (res1) => {
        //     console.log(res1, 'tempFielPath tempFilePath')
        //     wx.showToast({
        //       title: '下载成功',
        //     })
        //   },
        //   fail: (res1) => {
        //     wx.showToast({
        //       title: '下载失败',
        //     })
        //   }
        // })
      },
      complete: () => {
        console.log('调用了吗 调用了吗')
        // wx.hideLoading()
      },
      fail: () => {
        console.log('fail fail fail')
        wx.showToast({
          title: '下载失败',
          icon: 'error'
        })
        wx.hideLoading()
      }
    })
  },
  hideImageShow() {
    this.setData({
      isShowImg: false
    })
  },
  navigateToAddCertify() {
    if (app.globalData.curRole === '企业管理') {
      wx.navigateTo({
        url: '/pages/addcertify/addcertify?companyId=' + this.data.companyId,
      })
    } else if (app.globalData.curRole) {
      wx.showToast({
        title: '不具备权限',
      })
    }
    
  },
  searchCertify(event) {
    console.log(event, 'searchCertify searchCertify')
    if (this.data.type === 1) {}
    if (this.data.type === '1') {
      //应急预案
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '应急预案',
          certificateName: event.detail.value
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    } else if (this.data.type === '2') {
      // 双体系
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '双体系证书',
          certificateName: event.detail.value
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    } else if (this.data.type === '3') {
      // 标准化
      wx.request({
        url: app.globalData.appBaseUrlV2 + '/api1/enterpriseCertificate/page',
        method: 'GET',
        header: {
          Authorization: app.globalData.Authorization
        },
        data: {
          companyId: this.data.companyId,
          category: '标准化',
          certificateName: event.detail.value
        },
        success: (res) => {
          console.log(res, 'api/enterpriseCertificate/page')
          this.setData({
            certifyList: [...res.data.content.map(item => {
              return {
                type: item.category,
                name: item.name,
                uploadDate: item.uploadDate,
                validDate: item.expirationDate,
                id: item.id,
                filepath: item.filePath
              }
            })]
          })
        }
      })
    }
  }
})