// pages/dangeredit/dangeredit.js
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    checkImg:false,
    showButton:false,
    // 企业id
    companyId: app.globalData.currentEnter.companyId,
    // 隐患验收人
    hdAcceptancePerson: "",
    // 隐患描述
    comment: '',
    // 隐患id
    hdId: -1,
    // 隐患描述
    hdDesc: "",
    // 检查日期
    hdInspectDate: '',
    // 检查专家
    hdInspectExpert: '',
    // 隐患级别 1 2
    hdLevel: 1,
    // 隐患名称
    hdName: '',
    // 隐患图片
    hdPic: null,
    // 隐患整改日期
    hdRectificationDate: '',
    // 隐患整改图片
    hdRectificationPic: null,
    // 隐患整改建议
    suggestion:'',
    hdRectificationSug: '',
    // 隐患状态 0 正在整改 1 整改完毕
    hdStatus: 1,
    // 隐患预览图片
    imgsrcurl: '',
    // 整改预览照片
    imgrecturl: '',
    // 隐患图片文件路径
    hdFilePath: '',
    // 整改图片文件路径
    rectFilePath: '',
    // 放大图片的路径
    enlargeUrl: '',
    topAnimation: {},
    curRole:'',
    isToEnLarge: false,
    xcx:'xcx'
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options,'options')
    this.setData({
      curRole: app.globalData.curRole
    })
    const animation = wx.createAnimation({
      delay: 10, 
      timingFunction: 'linear'
    })
    this.animation = animation
    this.data.companyId = app.globalData.currentEnter.companyId
    this.setData(
      app.globalData.currentHD
    )
    // console.log(app.globalData.currentHD, 'currentHD')
    // 调用接口 获取图片
    wx.request({
      url: app.globalData.appBaseUrl + '/api/thHiddenDanger',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        companyId: app.globalData.currentEnter.companyId,
        hdId: app.globalData.currentHD.hdId,
        page: 0,
        size: 2000,
        sort: 'hdId,asc'
      },
      header: {
        Authorization: app.globalData.Authorization
      },
      success: (res) => {
        if (res.statusCode === 401) {
          wx.redirectTo({
            url: '/pages/login/login',
          })
        } else {
          if(res.data.content[0].hdstatus1===1|| this.data.curRole=='企业员工'){
            console.log(this.data.curRole)
            this.setData({
              showButton:false
            })
          }else{
            this.setData({
              showButton:true
            })
          }
          if (res.data.content && res.data.content[0] && res.data.content[0].hdPic) {
           
            
            this.setData({
              imgsrcurl: 'data:image/jpg;base64,' + res.data.content[0].hdPic
            })
          }
          if (res.data.content && res.data.content[0] && res.data.content[0].hdRectificationPic) {
            this.setData({
              imgrecturl: 'data:image/jpg;base64,' + res.data.content[0].hdRectificationPic,
              checkImg:true,

            })
          }
        }
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarTitle({
      title: '编辑隐患',
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
   // 输入整改评价
   inputEvaluation(event) {
    this.data.recEvaluation = event.detail.value
  },
  /**
   * 拍摄整改照片
   */
  takePhoto() {

    wx.chooseImage({
      success: (res) => {
        if(res.tempFilePaths[0]){
          this.setData({
            checkImg: true
          })
        }else{
          this.setData({
            checkImg: false
          })
        }
        console.log(res.tempFilePaths[0],'res.tempFilePaths[0]',this.data.checkImg)
        this.data.rectFilePath = res.tempFilePaths[0]
        wx.getFileSystemManager().readFile({
          filePath: res.tempFilePaths[0], // 选择图片返回的相对路径
          encoding: 'base64', // 编码格式
          success: res1 => { // 成功的回调
            this.setData({
              imgrecturl: 'data:image/png;base64,' + res1.data
            })
          }
        })
      }
    })
  },
  /**
   * 输入整改日期
   */
  inputRectDate(event) {
    this.setData({
      hdRectificationDate: event.detail.value 
      // hdRectificationDate: event.detail.value + ' 00:00:00'
    })
  },
    /**
   * 输入整改期限
   */
  inputRectification(event) {
    this.setData({
      recDeadLine: event.detail.value 
    })
  },
  /**
   * 输入验收人
   */
  inputAcceptancePer(event) {
    this.data.hdAcceptancePerson = event.detail.value
  },
  /**
   * 输入隐患状态
   */
  inputRectStatus(event) {
    if((this.data.imgrecturl=== "" || this.data.imgrecturl=== null||this.data.imgrecturl === 'null'||this.data.imgrecturl === undefined)&&event.detail.value==1){
      wx.showToast({
        title: '没有整改照片',
        icon: 'error',
        duration: 1000
      })
      this.data.hdStatus = event.detail.value 
      return
    }else{
      this.data.hdStatus = event.detail.value 
    }
    
    
  },
  /**
   * 提交修改
   */
  submitEdit() {
    if((this.data.imgrecturl=== "" || this.data.imgrecturl=== null||this.data.imgrecturl === 'null'||this.data.imgrecturl === undefined)&&this.data.hdStatus==1){
      wx.showToast({
        title: '没有整改照片',
        icon: 'error',
        duration: 1000
      })
      return
    }
    if (this.data.rectFilePath) {
      wx.showLoading({
        title: '上传中',
      })
      let formData = {}
      formData = {...this.data}
      delete formData.hdPic
      delete formData.hdRectificationPic
      delete formData.imgsrcurl
      delete formData.imgrecturl
      delete formData.hdFilePath
      delete formData.rectFilePath
      delete formData.entryDate
      if (!formData.hdInspectDate) {
        delete formData.hdInspectDate
      }
      if (!formData.hdRectificationDate) {
        delete formData.hdRectificationDate
      }
      if (
        formData.recDeadLine === "" ||
        formData.recDeadLine === null||formData.recDeadLine === 'null'
      ) {
        delete formData.recDeadLine;
      }
      if (
        formData.recEvaluation === "" ||
        formData.recEvaluation === null||formData.recDeadLine === 'null'
      ) {
        delete formData.recEvaluation;
      }
      if(formData.imgrecturl=== "" || formData.imgrecturl=== null||formData.imgrecturl === 'null'){
        console.log(111,formData.imgrecturl)
      }
      // if (this.formInfo.typeId === "" || this.formInfo.typeId === null) {
      //   formData.delete("typeId");
      // }
      // console.log('整改日期:' + this.data.rectFilePath)
      console.log('整改照片:' + this.data.imgrecturl)
      wx.uploadFile({
        filePath: this.data.rectFilePath,
        name: 'hdRectificationPic',
        url: app.globalData.appBaseUrl + '/api/thHiddenDanger/update',
        formData: formData,
        header: {
          Authorization: app.globalData.Authorization
        },
        success: (res) => {
          console.log(res, '文件编辑上传')
          wx.hideLoading()
          if (res.statusCode === 204) {
            wx.showToast({
              title: '编辑成功',
              icon: 'success'
            })
            wx.navigateBack()
          } else if (res.statusCode === 401) {
            wx.redirectTo({
              url: '/pages/login/login',
            })
          }
          else if (res.status === 400) {
            wx.showToast({
              title: res.message,
              icon: 'error'
            })
            wx.navigateBack()
          }
        },
        fail: () => {
          wx.hideLoading()
        }
      })
    }
    else {
      wx.showLoading({
        title: '上传中',
      })
      let formData = {}
      formData = {...this.data}
      console.log()
      delete formData.hdPic
      delete formData.hdRectificationPic
      delete formData.imgsrcurl
      delete formData.imgrecturl
      delete formData.hdFilePath
      delete formData.rectFilePath
      delete formData.entryDate
      if (!formData.hdInspectDate) {
        delete formData.hdInspectDate
      }
      if (!formData.hdRectificationDate) {
        delete formData.hdRectificationDate
      }
      // if(this.formInfo.recDeadLine)
      if (
        formData.recDeadLine === "" ||
        formData.recDeadLine === null||formData.recDeadLine === 'null'
      ) {
        delete formData.recDeadLine;
      }
      if (
        formData.recEvaluation === "" ||
        formData.recEvaluation === null||formData.recDeadLine === 'null'
      ) {
        delete formData.recEvaluation;
      }
      let that = this
      if((formData.imgrecturl=== "" || formData.imgrecturl=== null||formData.imgrecturl === 'null'||formData.imgrecturl === undefined)&&(that.data.imgrecturl=== "" || that.data.imgrecturl=== null||that.data.imgrecturl === 'null'||that.data.imgrecturl === undefined)&&this.data.hdStatus==1){
        console.log('整改照片3:' + that.data.imgrecturl,formData.imgrecturl)
        wx.showToast({
          title: '选择整改照片',
          icon: 'error',
          duration: 1000
        })
        return
      }else{
        console.log('整改照片4:' + this.data.imgrecturl)
      }
      // if (this.formInfo.typeId === "" || this.formInfo.typeId === null) {
      //   formData.delete("typeId");
      // }
      wx.request({
        url: app.globalData.appBaseUrl + '/api/thHiddenDanger/update',
        method: 'POST',
        header: {
          'content-type': 'multipart/form-data; boundary=XXX',
          Authorization: app.globalData.Authorization
        },
        data: this.formatFormData(formData),
        success: (res) => {
          console.log(res, '上传成功了吗afhdhsfhhdsfhadsf')
          if(res.statusCode===204){
          wx.showToast({
            title: '编辑成功',
            icon: 'success',
            duration: 2000
          })
          setTimeout(() => {
            wx.navigateBack()
          }, 2000);
          
        }else if(res.statusCode===400){
          wx.showToast({
            title: res.data.message,
            icon: 'error',
            duration: 2000
          })
          setTimeout(() => {
            wx.navigateBack()
          }, 2000);
        }
        },
        fail: () => {},
        complete: () => {
          wx.hideLoading()
        }
      })
    }
  },
  // 格式化 multipart/formdata
  formatFormData(formdata) {
    let dataString = '\r\n--XXX'
    for (const key in formdata) {
      dataString += `\r\nContent-Disposition: form-data; name="${key}"\r\n\r\n${formdata[key]}\r\n--XXX`
    }
    return dataString
  },
  toEnlargePicByHiddenPic() {
    this.animation.bottom(0).step()
    this.setData({
      topAnimation: this.animation.export(),
      enlargeUrl: this.data.imgsrcurl,
      isToEnLarge: true
    })
    // toEnlargePicByRectPic
  },
  toEnlargePicByRectPic() {
    this.animation.bottom(0).step()
    this.setData({
      topAnimation: this.animation.export(),
      enlargeUrl: this.data.imgrecturl,
      isToEnLarge: true
    })
  },
  toCancelEnlargePic() {
    this.animation.bottom('-100%').step()
    this.setData({
      topAnimation: this.animation.export(),
      isToEnLarge: false
    })
  }
})