// pages/testpaper/testpaper.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    afterSubmit:false,
    singleQuestions: [
    ],
    multiQuestions: [
    ],
    checkQuestions: [
    ],
    questions: [
      {
        questionType: 'multiple',
        questionOutline: '你迫切需要哪方面的培训',
        questionList: [
          '公司企业文化、企业愿景方面',
          '岗位技能方面',
          '团队管理方面',
          '目标及时间管理方面'
        ]
      },
      {
        questionType: 'single',
        questionOutline: '你迫切需要哪方面培训',
        questionList: [
          '公司企业文化、企业愿景方面',
          '岗位技能方面',
          '团队管理方面',
          '目标及时间管理方面'
        ]
      },
      {
        questionType: 'check',
        questionOutline: '你迫切需要哪些培训',
        questionList: [
          '公司企业文化、企业愿景方面',
          '岗位技能方面'
        ]
      }
    ],
    singleScore: 0,
    multiScore: 0,
    justifyScore: 0,
    singleQuestionNum: 0,
    multiQuestionNum: 0,
    justifyQuestionNum: 0,
    isShowExamPage: false,
    resultScore: 0,
    isToScroll: true,
    id: -1,
    isExam: false,
    closeBtnImage: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAA5pJREFUWEfFl0mIXUUUhr8f1IXzRrIwSoyCoAQcQCGCGgXjFCcw7tSABmOMGnBjTCBi0I1g4hAlCRjdqaDGOAbUuFBQiAqiIDgEh4W4UaMuVPjlb+o21bfvve9196ILHt2v6gz/qXPqP+eJeV6aZ//MCIDt04BrgRuABeWTGH4pn5eBPZK+GTewsQDYvgS4B7hmTMOvAdskvTdKfhCA7eOAR4HbWoYOAN8BP5X9hcBi4NyW3C7gPkm/9wHpBWB7CZBIFhXlj4FHgPcl/dFl0PaxwDLgfuD8InMwNyfpiy6dTgC2TykRNjqb41zSP6OuNOe2jyggotesxZK+b+tPA2D7KCBXfHoRXi5p3ziO2zK2LwPeKftfJ0WS/qrlugA8C9za5FbSz7Nx3ujYPrGqld2SVvUCsB3HAZB1vaRX5+K8AnEd8Er5vkrS7uZs8gZsHw98Vopur6QpT852Kjy1IUkv9RThxWX/kKSkcXLZTkGvAFKUZ0v6LYc1gBrlCkmvd+TUZW+7pLUtB08Bd04YlbpSezWwt327NYDHgHuTL0kn9UR4IfBBOVsvaWv+tx296Gctk7S/R/9HIJyxVdL69g18CCwFnpG0pi/3th8AtpTzS8vfd8vfzZIeHNB9GrgD+EjSBW0A4e9TgUEjJeJEHmr+tTg7oVBvbqJ32U6KkqpvJaWvTKmBQ8DR4wAoIJ4Dbi7enpd0y5DzopPC3gP8KemYuQLYAdxenO6UtHquAGaSgnD9wy2HGySlV8w6BU0RPilp3UAhrQReKOeTN1C+3yTpxQHdJ4C7+oowESWyg5JCONOW7bNKh8wz3SJpU8ntQ8BGIM8sne/zHv00o3TXNLYN7RpYDrxdFKcRke0jgTeAsN0uSU30Eyq2d5a5IRxwlaS/axC2ayK6XNJEk6qJKL08PfvkMFYHFTc0G6brI5rMAhN42jIVFf8ALGlmiimUWb3TGFnZx/mjqr19bvtGoKmNtZK2NzJdnP0mcEUROFPSVzN12Lr6M4Avy95bkq6sz7sAHAb8WwktnO1M0JoFYvJwSf8NAigFVT+1bM14NrBdd9fY6HyiQ0NpXbUxkFa6o6tNd1R7WDG9v1md7X3KK+jKs+3zgHSwc6rzjOKZFfJi6rE8U3RAp90261NgjaRP+upo5A+TMuHeXbpfbXyoNgNsG/D4qEl6JIDGSxnZwgUXAbmZrp9miTQDy/5m5Br1gsYGMMrQbM/nHcD/KsVxMIuPd2kAAAAASUVORK5CYII=',
    shuImg: 'https://whjqaqscxt.weihai.cn/fonts/shu.png'
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options, 'options options')
    // singleScore: 0,
    // multiScore: 0,
    // justifyScore: 0,
    // this.data.singleScore = parseInt(options.singleScore)
    // this.data.multiScore = parseInt(options.multiScore)
    // this.data.justifyScore = parseInt(options.justifyScore)
    this.setData({
      singleScore: parseInt(options.singleScore),
      multiScore: parseInt(options.multiScore),
      justifyScore: parseInt(options.justifyScore)
    })
    this.data.id = options.id
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api1/onlineExamPaper/findSubject',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        id: options.id
      },
      success: (res) => {
        console.log(res, 'wx.request wx.request ')
        res.data.forEach(item => {
          item.result = ''
        })
        this.setData({
          singleQuestions: res.data.filter(item => item.type === '单选题').map(item => {
            const questionItem = []
            if (item.optiona) {
              questionItem.push(item.optiona)
            }
            if (item.optionb) {
              questionItem.push(item.optionb)
            }
            if (item.optionc) {
              questionItem.push(item.optionc)
            }
            if (item.optiond) {
              questionItem.push(item.optiond)
            }
            if (item.optione) {
              questionItem.push(item.optione)
            }
            if (item.optionf) {
              questionItem.push(item.optionf)
            }
            return {
              ...item,
              questionOutline: item.question,
              questionList: questionItem
            }
          }),
          multiQuestions: res.data.filter(item => item.type === '多选题').map(item => {
            const questionItem = []
            if (item.optiona) {
              questionItem.push(item.optiona)
            }
            if (item.optionb) {
              questionItem.push(item.optionb)
            }
            if (item.optionc) {
              questionItem.push(item.optionc)
            }
            if (item.optiond) {
              questionItem.push(item.optiond)
            }
            if (item.optione) {
              questionItem.push(item.optione)
            }
            if (item.optionf) {
              questionItem.push(item.optionf)
            }
            return {
              ...item,
              questionOutline: item.question,
              questionList: questionItem
            }
          }),
          checkQuestions: res.data.filter(item => item.type === '判断题').map(item => {
            return {
              ...item,
              questionOutline: item.question,
              questionList: [item.optiona, item.optionb]
            }
          }),
          singleQuestionNum: res.data.filter(item => item.type === '单选题').length,
          multiQuestionNum: res.data.filter(item => item.type === '多选题').length,
          justifyQuestionNum: res.data.filter(item => item.type === '判断题').length
        })

      }
    })
    // setTimeout(() => {
    //   this.setData({
    //     isToScroll: false
    //   })
    // }, 100)
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    wx.setNavigationBarTitle({
      title: '考试内容'
    })
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },

  /**
   * 
   */
  checkboxChange(event) {
    console.log(event, 'hehehehehehehehehe')
  },
  /**
   * 
   */
  radioChange(event) {},
  checkChange() {},
  /**
   * 
   */
  submitTestPaper(event) {
   
    for(let i=0;i<this.data.singleQuestions.length;i++){
      if(this.data.singleQuestions[i].result===''||this.data.singleQuestions.result===null){
        wx.showToast({
          title: '单选题未填写',
          icon:'error'
        })
        return
      }
    }
    for(let i=0;i<this.data.multiQuestions.length;i++){
      if(this.data.multiQuestions[i].result===''||this.data.multiQuestions.result===null){
        wx.showToast({
          title: '多选题未填写',
          icon:'error'
        })
        return
      }
    }
    for(let i=0;i<this.data.checkQuestions.length;i++){
      if(this.data.checkQuestions[i].result===''||this.data.checkQuestions.result===null){
        wx.showToast({
          title: '判断题未填写',
          icon:'error'
        })
        return
      }
    }
   

    // 提交考卷
    console.log(this.data.singleQuestions)
    this.setData({
     
      isExam: true,
      singleQuestions: this.data.singleQuestions,
      multiQuestions: this.data.multiQuestions,
      checkQuestions: this.data.checkQuestions,
      isShowExamPage: true,
      resultScore: this.data.singleQuestions.filter(item => item.isAnswer).length * this.data.singleScore + this.data.multiQuestions.filter(item => item.isAnswer).length * this.data.multiScore + this.data.checkQuestions.filter(item => item.isAnswer).length * this.data.justifyScore
    })
    // wx.showModal({
    //   title: '您的考试分数',
    //   content: this.data.resultScore + ' 分'
    // })
    console.log(app.globalData.userInfo, 'app.globalData.userInfo')
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api1/onlineExamPaper/recordScore',
      method: 'post',
      header: {
        Authorization: app.globalData.Authorization
      },
      data: {
        paperId: this.data.id,
        score: this.data.resultScore,
        userId: app.globalData.userInfo.id
      },
      success: (res) => {
        console.log(res,'3333333')
        if(res){

        }
        console.log('上传成功       api/onlineExamPaper/recordScore')
      }
    })
    console.log(this.data.singleQuestions, 'this.singleQuestions')
    console.log(this.data.multiQuestions, 'this.multiQuestions')
    console.log(this.data.checkQuestions, 'this.checkQuestions')
  },
  /**
   * 
   */
  cancelmove(event) {
    console.log(event)
    // return false
    // return true
  },
  chooseSingle(event) {
    //event.detail.value
    const index = event.detail.value.split('|')[0]
    const index1 = event.detail.value.split('|')[1]
    if (index1 === '0') {
      this.data.singleQuestions[index].result = 'A'
    } else if (index1 === '1') {
      this.data.singleQuestions[index].result = 'B'
    } else if (index1 === '2') {
      this.data.singleQuestions[index].result = 'C'
    } else if (index1 === '3') {
      this.data.singleQuestions[index].result = 'D'
    } else if (index1 === '4') {
      this.data.singleQuestions[index].result = 'E'
    } else if (index1 === '5') {
      this.data.singleQuestions[index].result = 'F'
    }
    if (this.data.singleQuestions[index].result === this.data.singleQuestions[index].answer) {
      this.data.singleQuestions[index].isAnswer = true
    } else {
      this.data.singleQuestions[index].isAnswer = false
    }
  },
  chooseMulti(event) {
    //event.detail.value
    console.log(event, 'chooseMulti')
    if (!event.detail.value || event.detail.value.length === 0) {
      return
    }
    let result = []
    let index = -1
    event.detail.value.forEach(item => {
      index = item.split('|')[0]
      const index1 = item.split('|')[1]
      if (index1 === '0') {
        result.push('A')
      } else if (index1 === '1') {
        result.push('B')
      } else if (index1 === '2') {
        result.push('C')
      } else if (index1 === '3') {
        result.push('D')
      } else if (index1 === '4') {
        result.push('E')
      } else if (index1 === '5') {
        result.push('F')
      }
    })
    result = result.sort()
    console.log(result, 'result___________________________')
    console.log(result, 'result___________________________')
    if (result.length > 0) {
      this.data.multiQuestions[index].result = result.join('、')
    } else {
      this.data.multiQuestions[index].result = ''
    }
    if (this.data.multiQuestions[index].result === this.data.multiQuestions[index].answer) {
      this.data.multiQuestions[index].isAnswer = true
    } else {
      this.data.multiQuestions[index].isAnswer = false
    }
  },
  chooseJustify(event) {
    console.log(event, 'chooseJustify chooseJustify')
    const index = event.detail.value.split('|')[0]
    const index1 = event.detail.value.split('|')[1]
    if (index1 === '0') {
      this.data.checkQuestions[index].result = '对'
    } else if (index1 === '1') {
      this.data.checkQuestions[index].result = '错'
    }
    console.log(this.data.checkQuestions[index], 'this.data.checkQuestions')
    if (this.data.checkQuestions[index].result === this.data.checkQuestions[index].answer) {
      this.data.checkQuestions[index].isAnswer = true
    } else {
      this.data.checkQuestions[index].isAnswer = false
    }
  },
  closeMySelf(event) {
    console.log(event, 'cloiseMySelf closeMySelf')
    this.setData({
      isShowExamPage: false
    })
  },
  viewWrong() {
    this.setData({
      afterSubmit:true,
      isExam: true,
      isShowExamPage: false
    })
  },
  quitTest() {
    app.globalData.isNeedNavigateTo = true
    app.globalData.testPaperId = this.data.id
    app.globalData.singleScore = this.data.singleScore
    app.globalData.multiScore = this.data.multiScore
    app.globalData.justifyScore = this.data.justifyScore
    wx.navigateBack({
      delta: 1,
    })
  }
})