// pages/trainimg/trainimg.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    nature:'',
    isPullDown: false,
    companyId: '',
    curRole: app.globalData.curRole,
    trainImgList: [
    ]
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/trainNature',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization,
      },
      data: {
        county:app.globalData.appCounty,
        page: 0,
        size: 999,
      },
      success: (res) => {
        console.log(res, '培训影像管理 培训影像管理 培训影像管理 培训影像管理')
        this.setData({
          nature: res.data.content
        })
      }
    })
    this.setData({
      curRole: app.globalData.curRole
    })
    this.data.companyId = options.companyId
    wx.setNavigationBarTitle({
      title: '培训影像'
    })
    wx.setNavigationBarColor({
      backgroundColor: '#090D9C',
      frontColor: '#ffffff',
    })
    wx.request({
      url: app.globalData.appBaseUrlV2 + '/api/trainImage/pageTrainImage',
      method: 'get',
      header: {
        Authorization: app.globalData.Authorization,
      },
      data: {
        enterpriseId: this.data.companyId,
        page: 0,
        size: 999,
        sort: 'time,desc'
      },
      success: (res) => {
        console.log(res, '培训影像管理 培训影像管理 培训影像管理 培训影像管理')
        let trainAllList=[...res.data.content.map(item => {
          return {
            ...item,
            briefIntroduction: item.briefIntroduction,
            trainSum: item.peopleNum,
            uploadTime: item.time,
            uploadPos: item.location
          }
        })]
        for (let i = 0; i < trainAllList.length; i++) {
          for (let j = 0; j < this.data.nature.length; j++) {
            if (trainAllList[i].nature_id === this.data.nature[j].id) {
              trainAllList[i].name = this.data.nature[j].name;
            }
          }
        }
        console.log(trainAllList)
        this.setData({
          trainImgList:trainAllList
          // trainImgList: [...res.data.content.map(item => {
          //   return {
          //     ...item,
          //     briefIntroduction: item.briefIntroduction,
          //     trainSum: item.peopleNum,
          //     uploadTime: item.time,
          //     uploadPos: item.location
          //   }
          // })]
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  pullDownRefresh(event) {
    setTimeout(() => {
      this.setData({
        isPullDown: false
      })
    },1000)
  },
  navigateToTrainImgItem(event) {
    console.log(event, 'navigateToTrainImgItem navigateToTrainImgItem')
    app.globalData.currentTrainImg = event.currentTarget.dataset.index
    wx.navigateTo({
      url: '/pages/trainimgitem/trainimgitem'
    })
  },
  addTrainImg() {
    wx.navigateTo({
      url: '/pages/addtrainimg/addtrainimg?companyId=' + this.data.companyId,
    })
  }
})