'use strict'
const path = require('path')

const Mode = 'src';		// 'src'	'src-neuter'(中性)
// copy-webpack-plugin@4.5.2
const CopyWebpackPlugin = require('copy-webpack-plugin');
//var HtmlWebpackPlugin = require('html-webpack-plugin');
const defaultSettings = require('./'+Mode+'/settings.js');

function resolve(dir) {
  return path.join(__dirname, dir)
};

const name = defaultSettings.title; // 网址标题
const port = process.env.VUE_APP_LOCAL_PORT; // 端口配置
const VUE_APP_BASE_API = process.env.VUE_APP_BASE_API;

// All configuration item explanations can be find in https://cli.vuejs.org/config/
module.exports = {
	// hash 模式下可使用
	// publicPath: process.env.NODE_ENV === 'development' ? '/' : './',
	publicPath: '/',
	outputDir: 'dist',
	assetsDir: 'static',
	lintOnSave: process.env.NODE_ENV === 'development',
	productionSourceMap: false,
	//indexPath: 'index3.html',
	//integrity:true,
	lintOnSave:false,		// 关闭代码核查
	pages:{
		index: {
			entry: Mode+'/main.js',
			// 模板来源
			template: './public/index.html',
			// 在 dist/index.html 的输出
			filename: 'index.html',
			// 当使用 title 选项时，
			// template 中的 title 标签需要是 <title><%= htmlWebpackPlugin.options.title %></title>
			//title: "Index Page",
			//keywords: "333",
			//description: "444",
			// 在这个页面中包含的块，默认情况下会包含
			// 提取出来的通用 chunk 和 vendor chunk。
			chunks: ["index", "runtime", "chunk-libs", "chunk-elementUI"]
		},
		edge: {
			// 页面的入口文件
			entry: Mode+'/edge.js',
			// 页面的模板文件
			template: './public/edge.html',
			// build 生成的文件名称  例： dist/index.html
			filename: 'edge.html',
			chunks:["edge", "runtime", "chunk-libs", "chunk-elementUI"],
		}
	},
	devServer: {
		port: port,
		host: VUE_APP_BASE_API && VUE_APP_BASE_API.split(/\/\/|:/).slice(-2)[0],
		open: false,
		overlay: {
		  warnings: false,
		  errors: true
		},
		proxy: {
			'/api': {
				target: process.env.VUE_APP_BASE_API,
				changeOrigin: true,
				pathRewrite: {
				  '^/api': 'api'
				}
			},
			'/auth': {
				target: process.env.VUE_APP_BASE_API,
				changeOrigin: true,
				pathRewrite: {
				  '^/auth': 'auth'
				}
			},
			// 天气接口
			'/weather': {
				target: 'https://i.tianqi.com/',  // 真实请求URl
				changeOrigin: true, // 允许跨域
				pathRewrite: {  // 替换，通配/api的替换成/
					'^/weather': '/'
				}
			},
			'/ys7com': {
				target: 'https://open.ys7.com/api/lapp/token/get',  // 真实请求URl
				changeOrigin: true, // 允许跨域
				pathRewrite: {  // 替换，通配/api的替换成/
					'^/ys7com': '/'
				}
			},
		}
	},
	configureWebpack: {
		// provide the app's title in webpack's name field, so that
		// it can be accessed in index.html to inject the correct title.
		plugins: [
		  new CopyWebpackPlugin([{
			  from: "./static",
			  to: 'static'
		  }]),
		  new CopyWebpackPlugin([{
			  from: "./config",
			  to: 'config'
		  }])
		],
		name: name,
		resolve: {
		  alias: {
			'@': resolve(Mode+''),
			'@crud': resolve(Mode+'/components/Crud')
		  }
		}
	},
	chainWebpack(config) {
		config.plugins.delete('preload') // TODO: need test
		config.plugins.delete('prefetch') // TODO: need test

		// set svg-sprite-loader
		config.module
		  .rule('svg')
		  .exclude.add(resolve(Mode+'/assets/icons'))
		  .end()
		config.module
		  .rule('icons')
		  .test(/\.svg$/)
		  .include.add(resolve(Mode+'/assets/icons'))
		  .end()
		  .use('svg-sprite-loader')
		  .loader('svg-sprite-loader')
		  .options({
			symbolId: 'icon-[name]'
		  })
		  .end()

		// set preserveWhitespace
		config.module
		  .rule('vue')
		  .use('vue-loader')
		  .loader('vue-loader')
		  .tap(options => {
			options.compilerOptions.preserveWhitespace = true
			return options
		  })
		  .end()

		config
		  // https://webpack.js.org/configuration/devtool/#development
		  .when(process.env.NODE_ENV === 'development',
			config => config.devtool('cheap-source-map')
		  )

		config
		  .when(process.env.NODE_ENV !== 'development',
			config => {
			  config
				.plugin('ScriptExtHtmlWebpackPlugin')
				.after('html')
				.use('script-ext-html-webpack-plugin', [{
				// `runtime` must same as runtimeChunk name. default is `runtime`
				  inline: /runtime\..*\.js$/
				}])
				.end()
			  config
				.optimization.splitChunks({
				  chunks: 'all',
				  cacheGroups: {
					libs: {
					  name: 'chunk-libs',
					  test: /[\\/]node_modules[\\/]/,
					  priority: 10,
					  chunks: 'initial' // only package third parties that are initially dependent
					},
					elementUI: {
					  name: 'chunk-elementUI', // split elementUI into a single package
					  priority: 20, // the weight needs to be larger than libs and app or it will be packaged into libs or app
					  test: /[\\/]node_modules[\\/]_?element-ui(.*)/ // in order to adapt to cnpm
					},
					commons: {
					  name: 'chunk-commons',
					  test: resolve(Mode+'/components'), // can customize your rules
					  minChunks: 3, //  minimum common number
					  priority: 5,
					  reuseExistingChunk: true
					}
				  }
				})
			  config.optimization.runtimeChunk('single')
			}
		  );
	},
	transpileDependencies: [
		//'vue-echarts',
		'resize-detector'
	]
}
