import request from '@/utils/request'

export function login(data) {
	var param = {
		username: data.username, 
		password: data.password, 
		code: data.code, 
		uuid: data.uuid, 
		areaId: data.areaId, 
	};
	return request({
		url: 'auth/login',
		method: 'post',
		data: param
	})
}

export function getInfo() {
  return request({
    url: 'auth/info',
    method: 'get'
  })
}

export function setInfo(areaId) {
	return request({
		url: 'auth/updateInfo',
		method: 'post',
		data: {
			areaId:areaId
		}
	})
}

export function getCodeImg() {
  return request({
    url: 'auth/code',
    method: 'get'
  })
}

export function logout() {
  return request({
    url: 'auth/logout',
    method: 'delete'
  })
}
