import Vue from "vue";
import Router from "vue-router";
//import Layout from "../layout/index";
import HomeLayout from "../layout/home";

Vue.use(Router);

export const constantRouterMap = [
	{
        path: "/plus/login",
        meta: { title: "登录login", noCache: true },
        component: (resolve) => {
			require(["@/views/system/user/login"], resolve)
        },
        hidden: true
    },
    {
        path: "/404",
		redirect: "/dashboard",
        component: resolve => require(["@/views/features/404"], resolve),
        hidden: true
    },
    {
        path: "/401",
        component: resolve => require(["@/views/features/401"], resolve),
        hidden: true
    },
    {
		path: "/redirect",
		//component: Layout,
		component: HomeLayout,
		hidden: true,
		children: [
			{
				path: "/redirect/:path*",
				component: resolve => require(["@/views/features/redirect"], resolve)
			}
		]
	},
	{
        path: "/",
        component: HomeLayout,
        redirect: "/dashboard",
		children: [
		  {
			path: 'dashboard',
			component: (resolve) => require(['@/views/home_manage'], resolve),
			name: 'Dashboard',
			meta: { title: '主页面', icon: 'index', affix: true, noCache: true }
		  }
		]

    },
    {
		path: "/user",
		//component: Layout,
		component: HomeLayout,
		hidden: true,
		redirect: "noredirect",
		children: [
			{
				path: "center",
				component: resolve => require(["@/views/system/user/center"], resolve),
				name: "个人中心",
				meta: { title: "个人中心" }
			}
		]
    },
    {
        path: "/edge/Screen",
        meta: { title: "数据大屏", noCache: true },
        component: (resolve) => {
            return require(["@/views/Screen/index"], resolve)
        },
        hidden: true
    },
	{
        path: "/edge/ScreenFX",
        meta: { title: "风险数据大屏", noCache: true },
        component: (resolve) => {
            return require(["@/views/Screen/fx"], resolve)
        },
        hidden: true
    },
];

export default new Router({
    // mode: 'hash',
    mode:"history",
	//base: '/mobile/',
    scrollBehavior: () => ({ y: 0 }),
    routes: constantRouterMap
});
