
import { Notification } from 'element-ui';
import request from '@/utils/request';
import { Tools } from './common';
import { Highchart } from '@/assets/js/chartTemplates.js';
import { initData, download } from '@/api/data';

//var baseAPI = process.env.VUE_APP_LOCAL_API + '/';
var baseAPI = process.env.NODE_ENV
	=== 'development' ? process.env.VUE_APP_LOCAL_API + '/' : (VUE_APP_API.ServiceURL || process.env.VUE_APP_LOCAL_API) + '/';
var DownloadUrl = process.env.VUE_APP_Download + '/';

var reqPublic = function (url, type, param, opts) {
	type = type.toLowerCase();
	var paramKey = type === 'get' ? 'params' : 'data', opts = opts || {};
	var reqConfig = {
		url: url,
		method: type,
	};
	reqConfig[paramKey] = param;
	opts.responseType && (reqConfig['responseType'] = opts.responseType);
	return request(reqConfig)
};

var reqApis = function () {
	return {
		//donwloadURl:DownloadUrl,
		getWeather: function (param) {
			return request({
				url: process.env.VUE_APP_BASE_API + '/weather',
				method: 'post',
				params: param
			})
		},
		getRules: function (baseInfo) {
			var rules = {};
			for (var key in baseInfo) {
				var item = baseInfo[key];
				if (item.must) {
					var typeStr = item.type ? '请选择' : '请输入';
					var rule = { required: true, message: typeStr + item.name, trigger: 'blur' };
					item.ruleType && (rule.type = item.ruleType)
					rules[key] = [rule];
				};
			}; return Object.keys(rules)[0] ? rules : void 0;
		},
		// 根据设备code获取设备字典列表
		sensorListByCode: function (param) {
			return reqPublic('/tab/drybeachequipinfor/sensorList', 'get', param)
		},
		// 设备在线状态字典
		getDictDeviceStatus: function () {
			return reqPublic('/dic/alarm/status', 'get', {})
		},
		getBaseParams: function (searchItem) {
			var searchItem = searchItem || reqApi.common.getSearchParam(this.form) || {};
			var param = searchItem || {};
			param.page = this.table.page - 1;
			param.size = this.table.size;
			param.sort = 'date,desc';
			return param;
		},
		common: {
			requstEdge: function (type, url, param) {
				var param = param || {};
				return reqPublic(url, type, param).then((res) => {
					if (res && res.code === 200) {
						return res
					} else {
						Notification({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};
				}).catch(function (error) {
					console.log('catch ________________ ', error);
				});
			},
			getRequst: function (searchItem) {
				var param = reqApi.getBaseParams.call(this);
				this.table.loading = true;
				this.pageApi.request('get', param).then((res) => {
					this.table.loading = false;
					if (res && res.code) {
						var body = res.body || {};
						var list = body.list || [];
						this.table.dataList = list;
						this.table.total = body.total * 1;
					} else {
						this.$notify({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};
				}).catch(function (error) {
					this.table.loading = false;
				})
			},
			removeRequst: function (item) {
				return this.pageApi.request('delete', item).then((res) => {
					if (res.code === 200) {
						this.$notify({
							title: '删除成功！',
							type: 'success',
							duration: 2500
						});
						this.loadData()
					} else {
						this.$notify({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};
				});
			},
			addRequst: function (item) {
				return this.pageApi.request('post', item).then((res) => {
					this.form.visible = false;
					if (res.code === 200) {
						this.$notify({
							title: '添加成功！',
							type: 'success',
							duration: 2500
						});
						this.loadData()
					} else {
						this.$notify({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};
				}).catch(function (error) {
					this.form.status.cu = 0
				});
			},
			putRequst: function (item) {
				return this.pageApi.request('put', item).then((res) => {
					this.form.visible = false;
					if (res.code === 200) {
						this.$notify({
							title: '修改成功！',
							type: 'success',
							duration: 2500
						});
						this.loadData()
					} else {
						this.$notify({
							title: res.msg,
							type: 'error',
							duration: 2500
						})
					};
				}).catch(function (error) {
					this.form.status.cu = 0
				});
			},
			upload: function (e, key) {
				var tag = e.target || e.srcElement;
				var file = tag.files[0];
				if (file) {
					this.fullLoading = this.$loading({
						lock: true,
						text: 'Loading',
						spinner: 'el-icon-loading',
						background: 'rgba(0, 0, 0, 0.7)'
					});

					var data = new FormData();
					data.append('file', file);
					return this.pageApi.upload(data).then((res) => {
						this.fullLoading.close();
						if (res.code === 200) {
							tag.value = '';
							this.form.item[key] = res.body;
							this.$notify({
								title: '提示',
								message: '文件上传成功',
								type: 'success',
								duration: 5000
							})
						};
					}).catch(function (error) {
						this.form.status.cu = 0
					});
				};
			},
			getSearchParam: function (form) {
				var search = form.config.search, query = form.query, searchItem = {};
				if (Object.prototype.toString.call(search) === '[object Array]' && Object.keys(query || [])[0]) {
					for (var item of search) {
						var queryVal = query[item.word];
						if ((queryVal || typeof queryVal === 'number') && item.type !== "button") {
							var key = item.mode === 0 ? 'vague' : 'exact';
							if (item.type.indexOf('date') > -1) {
								searchItem[item.word || item.type] = queryVal.join(',');
							} else {
								var groub = searchItem[key] || (searchItem[key] = {});
								groub[item.word] = queryVal;
							};
						};
					};
				}; return searchItem
			},
			toSearch: function (form) {
				this.table.page = 1;
				var searchItem = {
					searchName: form.search.key,
					searchValue: form.query[form.search.key],
					limit: form.search.mode
				}
				this.loadData(searchItem)
			},
			toDownload: function (item) {
				var download = this.pageApi.download;
				var filePath = download.filePath;
				var fileName = item[download.keyName].indexOf('.') > 0 ? item[download.keyName] : '';
				if (filePath && fileName) {
					window.open(DownloadUrl + filePath + fileName);
				} else {
					this.$notify({
						title: '提示',
						message: '未找到要下载的文件！',
						type: 'warning',
						duration: 5000
					})
				};
			},
			toAdd: function () {		// 添加表单
				this.$refs['form1'] && this.$refs['form1'].clearValidate();
				this.form.title = '添加' + this.form.config.title;
				this.form.status.cu = 0;
				this.form.visible = true;
				this.form.reqType = 'add';
				var item = {}, Dict = this.Dict;
				for (var key in Dict.baseInfo) {
					var obj = Dict.baseInfo[key];
					item[key] = obj.default || obj.dataType || '';
				};
				this.form.item = item;
				Dict.addFormItem && Dict.addFormItem.call(this, item);
			},
			toEdit: function (item) {		// 添加表单
				var form = this.form, Dict = this.Dict;
				var cuForm = this.$refs['cuForm'];
				cuForm.$refs['form1'] && cuForm.$refs['form1'].clearValidate();
				form.title = '编辑' + form.config.title;
				form.status.cu = 0;
				form.visible = true;
				form.reqType = 'edit';
				form.item = item;
				Dict.editFormItem && Dict.editFormItem.call(this, item);
			},
			toDelete: function (item, opts) {		// 删除表单
				opts = opts || {};
				var text = opts.text || '确认删除该条数据吗?';
				this.$confirm(text, '提示', {
					confirmButtonText: '确定',
					cancelButtonText: '取消',
					type: 'warning'
				}).then((e) => {
					reqApi.common.removeRequst.call(this, item);
				}).catch((e) => {
				})
			},
			submitForm: function (form, item) {
				if (!this.form.status.cu) {
					form.validate(valid => {
						if (valid) {
							this.form.status.cu = 2;
							if (this.form.reqType === 'add') {
								reqApi.common.addRequst.call(this, item);
							} else {
								reqApi.common.putRequst.call(this, item);
							}
						} else {
							this.form.status.cu = 0
						}
					});
				};
			},
			toExports: function (item) {
				this.$confirm('您确认要导出该页数据吗?', '提示', {
					confirmButtonText: '确定',
					cancelButtonText: '取消',
					type: 'warning'
				}).then((e) => {
					var loading = this.$loading({
						lock: true,
						text: '请稍后.....',
						spinner: 'el-icon-loading',
						background: 'rgba(0, 0, 0, 0.7)'
					});
					var param = reqApi.getBaseParams.call(this);
					this.pageApi.download(param).then((res) => {
						loading.close();
						var name = this.pageApi.name + '数据' + Tools.Dates.format('yyyy-MM-dd HH:mm:ss');
						Tools.downloadFile(res, name, 'xlsx')
					})
				})
			},
			openCharts: function () {		// 内页共用图表
				var that = this;
				qf.UI.popupLayer({
					//title:'<div>标题</div>',
					html: '<div style="width:13rem;"></div>',
					onload: function (el) {
						var box = el.firstElementChild;
						box.innerHTML = '<div class="p-head" style="padding-top:5px;display:flex;align-items:center;"><div class="select" style="margin:0 15px 0 5px;"><select style="height:25px;min-width:100px;"></select></div><div class="date"></div><button style="margin-left:20px;"class="el-button el-button--small el-button--primary query">查询</button></div><div class="p-body" style="height:7rem;"><div class="chart26" style="height:100%;width:100%;border:1px solid #ccc;margin-top:10px;"></div></div><div style="margin-top:5px;"><button data-type="line" class="switch" style="margin-right:4px;">折线图</button><button data-type="column" class="switch">柱状图</button></div>';
						var headEl = box.firstElementChild;
						var selectEl = headEl.firstElementChild;
						var dateEl = selectEl.nextElementSibling;
						var chartEl = headEl.nextElementSibling.firstElementChild;
						var toDay = qf.UI.Dates().format('yyyy-MM-dd');
						var daterange = [toDay, toDay];
						var query = { daterange: daterange.join(','), sort: 'date,desc' };
						var selectData = that.Dict.selectList.sensorid;

						Tools.createOnSelect(selectEl.firstElementChild, selectData, {
							value: 'equipno',
							name: 'equipname',
							fn: function (value) {
								query['code'] = value
							},
							onload: function (value) {
								query['code'] = value
							},
						});

						qf.vue.render({
							el: dateEl,
							datakey: 'timeSpace',
							dataType: daterange,
							name: 'el-date-picker',
							style: "width:280px",
							attrs: {
								type: "daterange",
								"value-format": "yyyy-MM-dd",
								"range-separator": "至",
								"start-placeholder": "开始日期",
								"end-placeholder": "结束日期",
								clearable: ""
							},
							change: function (value) {
								query.daterange = (value || []).join(',');
							}
						});

						var chartOpts = {};
						box.onclick = function (e) {
							var tag = e.target || e.srcElement;
							if (tag.classList.contains('query')) {
								that.pageApi.reqchart(query).then((res) => {
									var body = res.body || [];
									chartOpts.cache = Highchart.template.rich.call(that, chartEl, body, chartOpts);
								})
							} else if (tag.classList.contains('switch')) {
								chartOpts.cache.update({ chart: { type: tag.dataset.type } })
							};
						};
						that.pageApi.reqchart(query).then((res) => {
							var body = res.body || [];
							chartOpts.cache = Highchart.template.rich.call(that, chartEl, body, chartOpts);
						})
					},
				})
			},
			getPermission: function (item) {
				var list = item.permission || [];
				var username = this.$store.state.user.user.username;
				return list.includes(username);
			},
		},
		// pageAPI
		edge: {
			Screen: {
				getViewsConfig: function (param) {
					return reqApi.common.requstEdge('get', 'sys/Area/visual', {});
				},
				relieveAlarm: function (param) {
					return reqApi.common.requstEdge('put', 'tab/Abnormal/histoty', param);
				},
				// 报警弹窗
				alterAbnormal: function (type, param) {
					return reqApi.common.requstEdge(type, 'tab/Abnormal/alterAbnormal', param);
				},
				appointDate: function (param) {
					return reqApi.common.requstEdge('put', 'tab/Abnormal/appointDate', param);
				},
			},
		},
		dashboard: {		// 首页
			switchPond: function (param) {
				return reqApi.common.requstEdge('post', 'tab/tailpondinfor/usertailpon', param);
			},
		},
		dataMonitor: {	// 数据监测
			bmwy: {	// 表面位移
				history: {
					name: '表面位移',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							// "velocityx": { name: "x形变速率(mm/h)" },
							// "dispx": { name: "x累计位移(mm)" },

							// "velocityy": { name: "y形变速率(mm/h)" },
							// "dispy": { name: "y累计位移(mm)" },
							// "velocityh": { name: "z形变速率(mm/h)" },
							// "disph": { name: "z累计位移(mm)" },
							"disph": { name: "监测值(mm)" },
							/* "cartesianX": { name: "大地坐标X" },
							"cartesianY": { name: "大地坐标Y" },
							"cartesianZ": { name: "大地坐标Z" }, */
							"state": { name: "是否报警", type: 'select', icon: 'el-icon-message-solid', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
							"difference": { name: "人工监测差异", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 3 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 3 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '监测项',
						warningLine: 'double',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
							{
								'type': 'select', 'name': '加入人工监测值', 'word': 'monitorType', 'mode': 1, val: 'id', key: 'name', 'width': '140px', 'change': function (val, item) {
									var that = this.$parent;
									var baseInfo = that.Dict.baseInfo;
									// 设置展示条件
									var partTableStatus = ~~that.form.query.monitorType;
									!that.Dict.valueName && (that.Dict.valueName = baseInfo["jcvalue"].name);
									baseInfo["jcvalue"].name = that.Dict.valueName + '(' + item.name + ')';
									baseInfo["jcvalue"].table = partTableStatus;
									baseInfo["jctime"].table = partTableStatus;
									baseInfo["difference"].table = partTableStatus;
									//that.table.page = 1;
									that.loadData()
								}, clear: function () {
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
						baseInfo["difference"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/mp/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/mp/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/mp/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			gt: {	// 干滩
				history: {
					name: '干滩监测',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							"lenth": { name: "长度(m)" },
							// "safeheight": { name: "坡度(度)" },
							// "angle": { name: "高程(m)" },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
							"difference": { name: "人工监测差异", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 1 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 1 }).then(function (res) {
									return res.body || [];
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '干滩',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
							{
								'type': 'select', 'name': '加入人工监测值', 'word': 'monitorType', 'mode': 1, val: 'id', key: 'name', 'width': '140px', 'change': function (val, item) {
									var that = this.$parent;
									var baseInfo = that.Dict.baseInfo;
									// 设置展示条件
									var partTableStatus = ~~that.form.query.monitorType;
									!that.Dict.valueName && (that.Dict.valueName = baseInfo["jcvalue"].name);
									baseInfo["jcvalue"].name = that.Dict.valueName + '(' + item.name + ')';
									baseInfo["jcvalue"].table = partTableStatus;
									baseInfo["jctime"].table = partTableStatus;
									baseInfo["difference"].table = partTableStatus;
									//that.table.page = 1;
									that.loadData()
								}, clear: function () {
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/db/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/db/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/db/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			jrx: {	// 浸润线
				dissect: {	// 剖面管理
					name: '剖面',
					Dict: {
						baseInfo: {
							"name": { name: "剖面名称", must: true, },
							"code": { name: "剖面编号", must: true, },
							"height": { name: "剖面高度(m)", must: true, default: 100 },
							"width": { name: "剖面宽度(m)", must: true, default: 100 },
							//"type": { name: "图表类型", type:'radio', must:true, default:'arcdiagram', key:'name', val:'value'},
							"sdeg": { name: "水区扇形起始角(默认为10)", must: true, default: 10 },
							"diameter": { name: "绘制直径(默认为2)", must: true, default: 2 },
							"drys": { name: "关联设备", must: true, type: 'select', multiple: true, val: 'equipno', key: 'equipname', },
						},
						selectList: {
							drys: function () {
								return reqApi.sensorListByCode({ code: 5 }).then(function (res) {
									return res.body || []
								});
							},
							type:[
								{name:'弧形图', value:'arcdiagram',},
								{name:'折线图', value:'polyarea',},
							],
						},
					},
					config: {
						formWidth: '440px',
						labelWidth: '120',
						operWidth: '180',
						title: '剖面',
						buttons: [
							{
								'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
									item = Object.assign({}, item);
									reqApi.common.toEdit.call(this.$parent, item);
								}
							},
							{
								'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
									reqApi.common.toDelete.call(this.$parent, item/* , {text:text} */);
								}
							}
						],
						otherBtn: [
							{
								type: 'primary', icon: 'el-icon-plus', name: '添加剖面', 'callback': function () {
									reqApi.common.toAdd.call(this);
								}
							},
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
						],
						search: [
						],
					},
					request: function (type, param) {
						return reqPublic('tab/jrx/dissect', type, param).then(function (res) {
							return res;
						});
					},
				},
				chartSteps: {	// 剖面台阶设置
					name: '台阶',
					Dict: {
						baseInfo: {
							"dissectid": { name: "剖面名称", must: true, type: 'select' },
							"name": { name: "台阶名称", must: true },
							"code": { name: "台阶编号" },
							"height": { name: "高度(m)" },
							"width": { name: "宽度(m)" },
							"slope": { name: "坡度(deg)" },
						},
						selectList: {
							dissectid: function () {
								return reqPublic('/tab/jrx/dissect/list', 'get', {}).then(function (res) {
									return res.body || [];
								});
							},
						},
					},
					config: {
						formWidth: '440px',
						labelWidth: '120',
						operWidth: '180',
						title: '台阶',
						buttons: [
							{
								'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
									item = Object.assign({}, item);
									reqApi.common.toEdit.call(this.$parent, item);
								}
							},
							{
								'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
									reqApi.common.toDelete.call(this.$parent, item/* , {text:text} */);
								}
							}
						],
						otherBtn: [
							{
								type: 'primary', icon: 'el-icon-plus', name: '添加台阶', 'callback': function () {
									reqApi.common.toAdd.call(this);
								}
							}
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
						],
						search: [
						],
					},
					request: function (type, param) {
						if (type === 'put') {
							param.slope = param.slope || 0;
							param.height = param.height || 0;
							param.width = param.width || 0;
						};
						return reqPublic('tab/jrx/steps', type, param)
					},
				},
				history: {
					name: '浸润线',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							//"stage": { name: "水位(m)" },
							"depth": { name: "埋深(m)" },
							"jrxTrepanning": { name: "孔深(m)" },
							"state": { name: "是否报警", type: 'select', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
							"difference": { name: "人工监测差异", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 5 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 5 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '浸润线',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
							{
								'type': 'select', 'name': '加入人工监测值', 'word': 'monitorType', 'mode': 1, val: 'id', key: 'name', 'width': '140px', 'change': function (val, item) {
									var that = this.$parent;
									var baseInfo = that.Dict.baseInfo;
									// 设置展示条件
									var partTableStatus = ~~that.form.query.monitorType;
									!that.Dict.valueName && (that.Dict.valueName = baseInfo["jcvalue"].name);
									baseInfo["jcvalue"].name = that.Dict.valueName + '(' + item.name + ')';
									baseInfo["jcvalue"].table = partTableStatus;
									baseInfo["jctime"].table = partTableStatus;
									baseInfo["difference"].table = partTableStatus;
									//that.table.page = 1;
									that.loadData()
								}, clear: function () {
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/st/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/st/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/st/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			ksw: {	// 库水位
				history: {
					name: '库水位',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							"stage": { name: "水位" },
							"state": { name: "是否报警", type: 'select', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"difference": { name: "人工监测差异", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },

						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 2 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 2 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '监测项',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									this.table.page = 1;
									this.loadData()
								}
							},
							{
								'type': 'select', 'name': '加入人工监测值', 'word': 'monitorType', 'mode': 1, val: 'id', key: 'name', 'width': '140px', 'change': function (val, item) {
									var that = this.$parent;
									var baseInfo = that.Dict.baseInfo;
									// 设置展示条件
									var partTableStatus = ~~that.form.query.monitorType;
									!that.Dict.valueName && (that.Dict.valueName = baseInfo["jcvalue"].name);
									baseInfo["jcvalue"].name = that.Dict.valueName + '(' + item.name + ')';
									baseInfo["jcvalue"].table = partTableStatus;
									baseInfo["jctime"].table = partTableStatus;
									baseInfo["difference"].table = partTableStatus;
									//that.table.page = 1;
									that.loadData()
								}, clear: function () {
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["difference"].table = 0;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/wt/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/wt/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/wt/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			jyl: {	// 降雨量
				history: {
					name: '降雨量',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							// "rainfall": { name: "监测值" },
							// "danwei": { name: "单位" },
							"rainfall": { name: "瞬时雨量(mm/h)" },
							"threerainfall": { name: "3小时内雨量(mm)" },
							"sixrainfall": { name: "6小时内雨量(mm)" },
							"twelverainfall": { name: "12小时内雨量(mm)" },
							"dayrainfall": { name: "日累计雨量" },

							"state": { name: "是否报警", type: 'select', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
							"difference": { name: "人工监测差异", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 6 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 6 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '降雨量',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									var that = this;
									qf.UI.popupLayer({
										//title:'<div>标题</div>',
										html: '<div style="width:13rem;"></div>',
										onload: function (el) {
											var box = el.firstElementChild;
											var btngroub = '<div style="margin:0 2px 0 25px;color:#E6A23C;">当前：</div><div class="el-button-group"><button data-id="1" class="el-button el-button--primary el-button--small cu-btn cu-btn-null">1小时</button><button data-id="6" class="el-button el-button--primary el-button--small cu-btn cu-btn-null">6小时</button><button data-id="12" class="el-button el-button--primary el-button--small cu-btn cu-btn-null">12小时</button><button data-id="720" class="el-button el-button--primary el-button--small cu-btn cu-btn-null">1个月</button></div>';

											box.innerHTML = '<div class="p-head" style="padding-top:5px;display:flex;align-items:center;"><div class="select" style="margin:0 15px 0 5px;"><select style="height:25px;min-width:100px;"></select></div><div class="date"></div><button style="margin-left:20px;"class="el-button el-button--small el-button--primary query">查询</button>' + btngroub + '</div><div class="p-body" style="height:7rem;"><div class="chart26" style="height:100%;width:100%;border:1px solid #ccc;margin-top:10px;"></div></div><div style="margin-top:5px;"><button data-type="line" class="switch" style="margin-right:4px;">折线图</button><button data-type="column" class="switch">柱状图</button></div>';

											var headEl = box.firstElementChild;
											var selectEl = headEl.firstElementChild;
											var dateEl = selectEl.nextElementSibling;
											var chartEl = headEl.nextElementSibling.firstElementChild;
											var toDay = qf.UI.Dates().format('yyyy-MM-dd');
											var daterange = [toDay, toDay];
											var query = { daterange: daterange.join(','), sort: 'date,desc' };
											var selectData = that.Dict.selectList.sensorid;
											Tools.createOnSelect(selectEl.firstElementChild, selectData, {
												value: 'equipno',
												name: 'equipname',
												fn: function (value) {
													query['code'] = value
												},
												onload: function (value) {
													query['code'] = value
												},
											});

											qf.vue.render({
												el: dateEl,
												datakey: 'timeSpace',
												dataType: daterange,
												name: 'el-date-picker',
												style: "width:280px",
												attrs: {
													type: "daterange",
													"value-format": "yyyy-MM-dd",
													"range-separator": "至",
													"start-placeholder": "开始日期",
													"end-placeholder": "结束日期",
													clearable: ""
												},
												change: function (value) {
													query.daterange = (value || []).join(',');
												}
											});

											var chartOpts = {};
											box.onclick = function (e) {
												var tag = e.target || e.srcElement;
												if (tag.classList.contains('query')) {
													if (box.tagBtn) {
														box.tagBtn.classList.add('cu-btn-null');
														delete query.hours;
													};
													that.pageApi.reqchart(query).then((res) => {
														var body = res.body || [];
														chartOpts.cache = Highchart.template.rich.call(that, chartEl, body, chartOpts);
													})
												} else if (tag.classList.contains('cu-btn')) {
													box.tagBtn && box.tagBtn.classList.add('cu-btn-null');
													tag.classList.remove('cu-btn-null');
													box.tagBtn = tag;
													query.hours = ~~tag.dataset.id;
													that.pageApi.reqchart(query).then((res) => {
														var body = res.body || [];
														chartOpts.cache = Highchart.template.rich.call(that, chartEl, body, chartOpts);
													})
												} else if (tag.classList.contains('switch')) {
													chartOpts.cache.update({ chart: { type: tag.dataset.type } })
												};
											};
											that.pageApi.reqchart(query).then((res) => {
												var body = res.body || [];
												chartOpts.cache = Highchart.template.rich.call(that, chartEl, body, chartOpts);
											})
										},
									})
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
							{
								'type': 'select', 'name': '加入人工监测值', 'word': 'monitorType', 'mode': 1, val: 'id', key: 'name', 'width': '140px', 'change': function (val, item) {
									var that = this.$parent;
									var baseInfo = that.Dict.baseInfo;
									// 设置展示条件
									var partTableStatus = ~~that.form.query.monitorType;
									!that.Dict.valueName && (that.Dict.valueName = baseInfo["jcvalue"].name);
									baseInfo["jcvalue"].name = that.Dict.valueName + '(' + item.name + ')';
									baseInfo["jcvalue"].table = partTableStatus;
									baseInfo["jctime"].table = partTableStatus;
									baseInfo["difference"].table = partTableStatus;
									//that.table.page = 1;
									that.loadData()
								}, clear: function () {
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
						baseInfo["difference"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/rg/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/rg/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/rg/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			nbwy: {	// 内部位移
				history: {
					name: '内部位移',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							// "dispA": { name: "a轴变化量(mm)" },
							"dispB": { name: "监测值(mm)" },
							// "cjvalue": { name: "沉降(mm)" },
							"state": { name: "是否报警", type: 'select' },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 4 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 4 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus().then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '内部位移',
						warningLine: 'double',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
						],
					},
					request: function (type, param) {
						return reqPublic('data/dm/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/dm/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/dm/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			sll: {	// 渗流量
				history: {
					name: '渗流量',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							"sllvalue": { name: "监测值" },
							"state": { name: "是否报警", type: 'select', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 9 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 9 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '监测项',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
							{
								'type': 'select', 'name': '加入人工监测值', 'word': 'monitorType', 'mode': 1, val: 'id', key: 'name', 'width': '140px', 'change': function (val, item) {
									var that = this.$parent;
									var baseInfo = that.Dict.baseInfo;
									// 设置展示条件
									var partTableStatus = ~~that.form.query.monitorType;
									!that.Dict.valueName && (that.Dict.valueName = baseInfo["jcvalue"].name);
									baseInfo["jcvalue"].name = that.Dict.valueName + '(' + item.name + ')';
									baseInfo["jcvalue"].table = partTableStatus;
									baseInfo["jctime"].table = partTableStatus;
									//that.table.page = 1;
									that.loadData()
								}, clear: function () {
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/sl/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/sl/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/sl/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			psl: {	// 排流量
				history: {
					name: '排流量',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							"pslvalue": { name: "流速(m³/h)" },
							// "psssvalue": { name: "瞬时流量(m³)" },
							"state": { name: "是否报警", type: 'select', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 7 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 7 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '排流量',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									this.table.page = 1;
									this.loadData()
								}
							},
						],
					},
					request: function (type, param) {
						return reqPublic('data/psl/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/psl/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/psl/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			wpb: {	// 外坡比
				history: {
					name: '外坡比',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							"value": { name: "监测值" },
							"state": { name: "是否报警", type: 'select', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
							"jcvalue": { name: "人工监测值", table: 0, form: 0, },
							"jctime": { name: "人工监测时间", table: 0, form: 0, },
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 16 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 16 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '外坡比',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							{
								type: 'success', icon: 'el-icon-s-data', name: '图表', 'callback': function () {
									reqApi.common.openCharts.call(this);
								}
							},
							{
								type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
									reqApi.common.toExports.call(this);
								}
							},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
							{
								'type': 'select', 'name': '加入人工监测值', 'word': 'monitorType', 'mode': 1, val: 'id', key: 'name', 'width': '140px', 'change': function (val, item) {
									var that = this.$parent;
									var baseInfo = that.Dict.baseInfo;
									// 设置展示条件
									var partTableStatus = ~~that.form.query.monitorType;
									!that.Dict.valueName && (that.Dict.valueName = baseInfo["jcvalue"].name);
									baseInfo["jcvalue"].name = that.Dict.valueName + '(' + item.name + ')';
									baseInfo["jcvalue"].table = partTableStatus;
									baseInfo["jctime"].table = partTableStatus;
									//that.table.page = 1;
									that.loadData()
								}, clear: function () {
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/wpb/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/wpb/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/wpb/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			hjjc: {	// 环境监测
				history: {
					name: '环境监测',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							"svalue": { name: "监测值" },
							"state": { name: "是否报警", type: 'select', },
							"time": {
								name: "监测时间", form: 0, type: "tableFormat", tableFormat: function (val) {
									return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
								}
							},
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 8 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 8 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '外坡比',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							/* {type:'success', icon:'el-icon-s-data', name:'图表', 'callback':function(){
								reqApi.common.openCharts.call(this);
							}},
							{type:'warning', icon:'el-icon-document', name:'导出', 'callback':function(){
								reqApi.common.toExports.call(this);
							}}, */
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							}
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{ 'type': 'checkbox', 'name': ' ', 'word': 'state', 'mode': 1, 'label': '报警状态', 'width': '140px', },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/sz/history', type, param)
					},
					reqchart: function (param) {
						return reqPublic('data/sz/imghistory', 'get', param)
					},
					download: function (param) {
						return reqPublic('data/sz/download', 'get', param, { responseType: 'blob' })
					},
				},
			},
			bpzd: {	// 爆破震动
				history: {
					name: '爆破震动',
					Dict: {
						baseInfo: {
							"sensorname": { name: "设备名称" },
							"sensorid": { name: "设备ID" },
							"speedx": { name: "x方向速度" },
							"speedy": { name: "y方向速度" },
							"speedz": { name: "z方向速度" },
							"speed": { name: "合成速度" },
							"addspeedx": { name: "x轴加速度" },
							"addspeedy": { name: "y轴加速度" },
							"addspeedz": { name: "z轴加速度" },
							"addspeed": { name: "加速度" },
							"pinlvx": { name: "x轴频率" },
							"pinlvy": { name: "y轴频率" },
							"pinlvz": { name: "z轴频率" },
							"jctime": {
								name: "监测时间", form: 0, 
							},
						},
						selectList: {
							sensorid: function () {
								return reqApi.sensorListByCode({ code: 19 }).then(function (res) {
									return res.body || []
								});
							},
							monitorType: function () {
								return reqPublic('/dic/artificial/jczxList', 'get', { code: 19 }).then(function (res) {
									return res.body || [];
								});
							},
							state: function () {
								return reqApi.getDictDeviceStatus({}).then(function (res) {
									return res.body || []
								});
							},
						},
					},
					config: {
						formWidth: '840px',
						labelWidth: '120',
						operWidth: '180',
						title: '外坡比',
						buttons: [
						],
						otherBtn: [
						],
						rightBtn: [
							{
								type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
									this.loadData()
								}
							},
							/* {type:'success', icon:'el-icon-s-data', name:'图表', 'callback':function(){
								reqApi.common.openCharts.call(this);
							}},
							{type:'warning', icon:'el-icon-document', name:'导出', 'callback':function(){
								reqApi.common.toExports.call(this);
							}},
							{
								type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
									Tools.cuPrint(this.$refs.cuTable);
								}
							} */
						],
						search: [
							{ 'type': 'select', 'name': '设备', 'word': 'sensorid', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
							{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
							{
								'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
									// 设置展示条件
									//var partTableStatus = ~~this.form.query.monitorType;
									//this.Dict.baseInfo["jcvalue"].table = partTableStatus;
									//this.Dict.baseInfo["jctime"].table = partTableStatus;
									this.table.page = 1;
									this.loadData()
								}
							},
						],
					},
					created: function () {
						var baseInfo = this.Dict.baseInfo;
						baseInfo["jcvalue"].table = 0;
						baseInfo["jctime"].table = 0;
					},
					request: function (type, param) {
						return reqPublic('data/zhidian/page', type, param)
					},
				},
			},
		},
		personMonitor: {		// 人工监测
			monitorPoints: {		// 监测点
				name: '监测点',
				Dict: {
					baseInfo: {
						"jcdname": { name: "监测点名称", must: true },
						"equipno": { name: "设备名称", must: true, type: 'select', key: 'equipname', val: 'equipno' },
						"remarks": { name: "备注", must: true },
						"time": {
							name: "添加时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
					},
					selectList: {
						equipno: function () {
							return reqPublic('/tab/drybeachequipinfor/pointDrys', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
					},
				},
				config: {
					formWidth: '460px',
					labelWidth: '120',
					operWidth: '180',
					title: '监测项',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加监测点', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '设备名称', 'word': 'jcdname', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('artificial/point', type, param)
				},
			},
			valueInput: {		// 监测值录入
				name: '监测值录入',
				Dict: {
					baseInfo: {
						"point_id": {
							name: "监测点", must: true, type: 'select', key: 'jcdname', val: 'id', 'change': function (val) {
								reqPublic('dic/artificial', 'get', { id: val }).then((res) => {
									var list = res.body || [], tagItem = list[0] || {};
									var fitem = this.form.item;
									fitem["jczx_id"] = tagItem["id"];
									fitem["content"] = tagItem["content"];
									fitem["implement"] = tagItem["implement"];
									fitem["precision"] = tagItem["precision"];
									this.Dict.selectList.jczx_id = list;
								})
							},
						},
						"jcziitemname": { name: "监测类型", must: true, form: 0, },
						"jczx_id": {
							name: "监测类型", must: true, type: 'select', key: 'name', val: 'id', table: 0, 'change': function (val, a, index) {
								var item = this.Dict.selectList.jczx_id[index];
								this.form.item["content"] = item["content"];
								this.form.item["implement"] = item["implement"];
								this.form.item["precision"] = item["precision"];
							},
						},
						"jc_man": { name: "监测人", must: true, },
						"content": { name: "说明", type: 'text', style: 'display:flex;width:100%;', },
						"implement": { name: "仪器", type: 'text', style: 'display:flex;width:100%;', },
						"precision": { name: "精度", type: 'text', style: 'display:flex;width:100%;', },
						"value": { name: "人工监测值", must: true },
						"time": { name: "添加时间", must: true, type: 'datetime', format: 'yyyy-MM-dd HH:mm:ss' },
					},
					selectList: {
						point_id: function () {
							return reqPublic('/artificial/point/pointList', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
						jc_man: function () {
							return reqPublic('/artificial/data/rquery', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
						jczx_id: function () {
							return reqPublic('/artificial/data/rtype', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
					},
				},
				config: {
					formWidth: '460px',
					labelWidth: '120',
					operWidth: '180',
					title: '监测项',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
								reqPublic('dic/artificial', 'get', { id: item.point_id }).then((res) => {
									this.Dict.selectList.jczx_id = res.body || [];
								});
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'select', 'name': '设备', 'word': 'point_id', 'mode': 1, 'width': '160px', key: 'jcdname', val: 'id', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'select', 'name': '监测类型', 'word': 'jczx_id', 'mode': 1, 'width': '160px', key: 'name', val: 'id', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'select', 'name': '监测人', 'word': 'jc_man', 'mode': 1, 'width': '160px', key: 'jc_man', val: 'jc_man', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('artificial/data', type, param)
				},
			},
		},
		personInspection: {		// 人工巡检
			checkItem: {		// 检查项
				Dict: {
					baseInfo: {
						"name": { name: "检查项名称", must: true },
						"update_time": {
							name: "更新时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
						"add_time": {
							name: "创建时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
					},
				},
				config: {
					formWidth: '460px',
					labelWidth: '120',
					operWidth: '120',
					title: '查检项',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加检查项', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [],
					search: [
						{
							'type': 'string', 'name': '检查项名称', 'word': 'name', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('ins/project', type, param)
				},
			},
			checkMode: {		// 检查类型
				Dict: {
					baseInfo: {
						"project_id": { name: "检查项", must: true, type: 'select', key: 'name', val: 'id' },
						"type": { name: "检查仪器/检查形式", must: true },
						"content": { name: "检查内容及要求", must: true, type: 'textarea', width: 300, rows: 4 },
						"update_time": {
							name: "更新时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
						"add_time": {
							name: "创建时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
					},
					selectList: {
						project_id: function () {
							return reqPublic('/ins/project/listing', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
					},
				},
				config: {
					formWidth: '460px',
					labelWidth: '120',
					operWidth: '120',
					title: '查检项',
					buttons: [
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加检查类型', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '检查仪器/检查形式', 'word': 'type', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('ins/children', type, param)
				},
			},
			checkResult: {		// 检查结果
				Dict: {
					baseInfo: {
						"title": { name: "检查标题", must: true },
						"text": { name: "检查结果", must: true },
						"project_id": {
							name: "检查项", must: true, type: 'select', key: 'name', val: 'id', 'change': function (val) {
								reqPublic('/ins/children/listing', 'get', { id: val }).then((res) => {
									var list = res.body || [], tagItem = list[0] || {};
									var fitem = this.form.item;
									fitem["child_id"] = tagItem["id"];
									fitem["content"] = tagItem["content"];
									this.Dict.selectList.child_id = list;
								})
							}
						},
						"child_id": {
							name: "检查类型", must: true, type: 'select', table: 0, key: 'type', val: 'id', 'change': function (val, a, b, index) {
								var item = this.Dict.selectList.child_id[index];
								this.form.item["content"] = item["content"];
							},
						},
						"type": { name: "检查类型", type: 'text', form: 0, style: 'display:flex;width:100%;', },
						"content": { name: "检查内容及要求", type: 'text', style: 'display:flex;width:100%;', },
						"image": {
							name: "照片", type: 'img', 'change': function (e, key) {
								var tag = e.target || e.srcElement, that = this;
								Tools.fileElTobase64(tag).then(function (res) {
									var base64 = res.base64;
									if (base64) {
										var imgBox = tag.parentNode.previousElementSibling;
										imgBox.style.display = 'block';
										that.form.item.image = res.base64;
									};
									tag.value = '';
								});
							}
						},
						"file": {
							name: "附件", type: 'filename', 'change': function (e, key) {
								var tag = e.target || e.srcElement, that = this;
								reqApi.common.upload.call(this, e, key);
							}
						},
						"update_time": {
							name: "更新时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
						"add_time": {
							name: "创建时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
					},
					selectList: {
						project_id: function () {
							return reqPublic('/ins/project/listing', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
						child_id: [],
					},
				},
				config: {
					formWidth: '480px',
					labelWidth: '120',
					operWidth: '180',
					title: '查检项',
					buttons: [
						{
							'fn': 'toDownload', 'type': 'success', 'icon': 'el-icon-download', 'callback': function (item) {
								if (item.file) {
									window.open(baseAPI + 'ins/data/download?id=' + item.id);
								} else {
									this.$notify({
										title: '未找到附件',
										type: 'error',
										duration: 3500
									});
								};
								return;
								/* var reqConfig = {
									//url: 'ins/data',
									url: baseAPI + 'ins/data/download',
									method: 'post',
									//method: 'get',
									//params: {id:1},
									data: {id:1},
									//params: {page: 0, size: 10, sort: 'date,desc'}
									responseType:'blob',
								};
								request(reqConfig).then(function(aaa){
									console.log('then ________________ ', aaa);
								}); */
							}
						},
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
								reqPublic('/ins/children/listing', 'get', { id: item.project_id }).then((res) => {
									this.Dict.selectList.child_id = res.body || [];
								})
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								reqApi.common.toDelete.call(this.$parent, item);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加人工巡检', 'callback': function () {
								reqApi.common.toAdd.call(this);
							}
						}
					],
					rightBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '标题', 'word': 'title', 'mode': 0, 'width': '180px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('ins/data', type, param)
				},
				/* download:{
					filePath:'upload/paper/',
					keyName:'paperfilename',
				}, */
				upload: function (data) {
					return reqPublic('ins/data/upload', 'post', data)
				},
			}
		},
		alarmManage: {		// 报警管理
			warning: {			// 预警值管理
				name: '历史记录',
				Dict: {
					baseInfo: {
						"equipname": { name: "类别", must: true, disabled: true },
						// "equipno": { name: "设备ID", must: true, disabled: true },
						// "bluealarm": {
						// 	name: "蓝色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
						// 		return val
						// 	}
						// },
						// "yellowalarm": {
						// 	name: "黄色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
						// 		return val 
						// 	}
						// },
						// "orangealarm": {
						// 	name: "橙色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
						// 		return val 
						// 	}
						// },
						// "redalarm": {
						// 	name: "红色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
						// 		return val 
						// 	}
						// },
						"fourlevelalarm": {
							name: "蓝色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
								return val
							}
						},
						"threelevelalarm": {
							name: "黄色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
								return val 
							}
						},
						"twolevelalarm": {
							name: "橙色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
								return val 
							}
						},
						"onelevelalarm": {
							name: "红色报警", must: true, type: 'tableFormat', tableFormat: function (val) {
								return val 
							}
						},
						
						// "fivedayone": {
						// 	name: "5天位移速率红色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "fivedaytwo": {
						// 	name: "5天位移速率橙色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "fivedaythree": {
						// 	name: "5天位移速率黄色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "fivedayfour": {
						// 	name: "5天位移速率蓝色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "dayone": {
						// 	name: "1天位移速率红色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "daytwo": {
						// 	name: "1天位移速率橙色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "daythree": {
						// 	name: "1天位移速率黄色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "dayfour": {
						// 	name: "1天位移速率蓝色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "hone": {
						// 	name: "1小时位移速率红色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "htwo": {
						// 	name: "1小时位移速率橙色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "hthree": {
						// 	name: "1小时位移速率黄色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						// "hfour": {
						// 	name: "1小时位移速率蓝色报警", must: false, type: 'tableFormat', tableFormat: function (val) {
						// 		return val ? (val + ' (' + this.unit + ')') : ''
						// 	}
						// },
						
					},
					selectList: {},
				},
				config: {
					formWidth: '440px',
					labelWidth: '120',
					operWidth: '120',
					title: '监测项',
					buttons: [
						//{'fn':'', 'type':'success', 'icon':'el-icon-more'},
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
						//{'fn':'toDelete', 'type':'danger', 'icon':'el-icon-delete'}
					],
					otherBtn: [
					],
					search: [
						{
							'type': 'string', 'name': '设备名称', 'word': 'equipname', 'mode': 0, 'width': '200px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('tab/Abnormal/level', type, param)
				},
			},
			history: {
				name: '报警记录',
				Dict: {
					baseInfo: {
						"equipno": { name: "设备名称", type: 'select', form: 0, key: 'equipname', val: 'equipno', },
						//"devicetype":{name:"设备类型"},
						//"state": { name: "状态", type: 'select', form: 0, },
						"alarmlevel": { name: "报警等级", type: 'select', form: 0, key: ' ', icon: 'el-icon-message-solid', color: 'red' },
						"evalue": {
							name: "报警值", form: 0, type: "tableFormat", tableFormat: function (val) {
								return val + ' (' + this.unit + ')'
							}
						},
						"time": {
							name: "报警时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
						"jchours": { name: "解除时长", table: 0, },
						"reason": { name: "报警原因" },
						"jcreason": { name: "解除报警原因" },
						
						"jcbjtime": {
							name: "解除有效时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return val && Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
						"updatetime": {
							name: "解除报警时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return val && Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
					},
					selectList: {
						state: [
							{ name: '报警', value: 1, color: 'red' },
							{ name: '已解除', value: 2, color: '#888' },
						],
						equipno: function () {
							return reqApi.sensorListByCode({}).then(function (res) {
								return res.body || []
							});
						},
						monitorType: function () {
							return reqPublic('/dic/artificial/jczxList', 'get', { code: 1 }).then(function (res) {
								return res.body || [];
							});
						},
						alarmlevel: function () {
							return reqPublic('/dic/alarm/level', 'get', {}).then(function (res) {
								return res.body || [];
							});
						},
					},
				},
				config: {
					formWidth: '440px',
					labelWidth: '120',
					operWidth: '120',
					title: '监测项',
					buttons: [
						{
							'type': 'primary', 'icon': 'el-icon-close-notification', 'isvalid': function (item) {
								return item.state !== 1
							}, 'callback': function (item) {
								item = Object.assign({}, item);
								item.jchours = '12';
								item.reason = '默认原因';
								item.jcreason = '默认解除报警原因';
								reqApi.common.toEdit.call(this.$parent, item);
							}
						},
					],
					otherBtn: [
					],
					rightBtn: [
						{
							type: 'primary', icon: 'el-icon-refresh', name: '刷新', 'callback': function () {
								this.loadData()
							}
						},
						{
							type: 'warning', icon: 'el-icon-document', name: '导出', 'callback': function () {
								var text = '您确认要导出该页数据吗?';
								this.$confirm(text, '提示', {
									confirmButtonText: '确定',
									cancelButtonText: '取消',
									type: 'warning'
								}).then((e) => {
									var loading = this.$loading({
										lock: true,
										text: '请稍后.....',
										spinner: 'el-icon-loading',
										background: 'rgba(0, 0, 0, 0.7)'
									});
									var param = reqApi.getBaseParams.call(this);
									this.pageApi.download(param).then((res) => {
										loading.close();
										var name = this.pageApi.name + '数据' + Tools.Dates.format('yyyy-MM-dd HH:mm:ss');
										Tools.downloadFile(res, name, 'xlsx')
									})
								})
							}
						},
						{
							type: 'default', icon: 'el-icon-printer', name: '打印', 'callback': function () {
								Tools.cuPrint(this.$refs.cuTable);
							}
						}
					],
					search: [
						{ 'type': 'select', 'name': '设备', 'word': 'equipno', 'mode': 1, 'width': '160px', val: 'equipno', key: 'equipname', },
						{ 'type': 'datetimerange', 'defaultTime': ['00:00:00', '23:59:59'], 'name': '日期范围', 'word': 'daterange', 'mode': 0, 'width': '380px', format: 'yyyy-MM-dd HH:mm:ss' },
						{ 'type': 'select', 'name': '报警状态', 'word': 'state', 'mode': 1, 'width': '160px', val: 'value', key: 'name', },
						//{'type':'checkbox', 'name':'', 'word':'state', 'mode':1, 'label':'报警状态', 'width':'140px', },
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('/tab/Abnormal/histoty', type, param)
				},
				download: function (param) {
					return reqPublic('tab/Abnormal/download', 'get', param, { responseType: 'blob' })
				},
			},
		},

		system: {
			pondManage: {			// 水库大坝管理
				Dict: {
					baseInfo: {
						"province": {
							name: "所在省份", must: true, type: 'select', val: 'code', table: 0, width: '130px', change: function (val) {
								var Dict = this.Dict, slist = Dict.selectList, fitem = this.form.item;
								delete fitem.city; delete fitem.cityarea;
								slist.cityarea = [];
								Dict.getRegion(val).then((res) => {
									slist.city = res;
								});
							}
						},
						"city": {
							name: "所在城市", must: true, type: 'select', val: 'code', table: 0, width: '130px', change: function (val) {
								var Dict = this.Dict, slist = Dict.selectList, fitem = this.form.item;
								delete fitem.cityarea;
								Dict.getRegion(val).then((res) => {
									slist.cityarea = res;
								});
							}
						},
						"cityarea": {
							name: "所在地区", must: true, type: 'select', key: 'name', val: 'code', table: 0, width: '130px', change: function (val) {
								var Dict = this.Dict, fitem = this.form.item;
								this.$forceUpdate();
								Dict.codeSplitJoint(fitem);
							}
						},
						"tailingno": { name: "水库大坝编号", must: true, form: 0 },
						"tailingname": { name: "水库大坝名称", must: true },
						"risk_entrance": { name: "风险大屏入口", type: 'select' },
						"address": {
							name: "水库大坝地址", /* must:true,  */disabled: true, type: 'map', style: "display:flex",
							mapConfig: {
								options: {
									zoom: 6,
									center: [107.260044, 36.737982],
									//showLabel: true,
									//pitch: 40,
									onload: function (cmap) {
										var item = this.form.item, self = this;
										this.Dict.cmap = cmap;
										if (item.longitude && item.latitude) {
											cmap.setCenter([item.longitude, item.latitude]);

											// 添加标记
											cmap.addMarker({
												lnglat: [item.longitude, item.latitude],
												title: '',
												draggable: true,
												dragend: function (e) {
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.address = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
														self.$forceUpdate();
													});
												},
											});
										};
									},
									click: function (e, cmap) {
										var that = this, lnglat = e.lnglat, form = this.form, item = form.item;
										// 如果为添加
										if (this.form.reqType === 'add') {
											cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
												form.item.address = addr;
												form.item.longitude = lnglat.lng;
												form.item.latitude = lnglat.lat;
											});

											cmap.marker && cmap.removeMarker();

											// 添加标记
											cmap.addMarker({
												lnglat: [lnglat.lng, lnglat.lat],
												title: '',
												draggable: true,
												dragend: function (e) {
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.address = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
													});
												},
											});
										};
									},
								},
							},
						},
						"longitude": { name: "经度", /* must:true,  */table: 0, form: 0 },
						"latitude": { name: "纬度", /* must:true,  */table: 0, form: 0 },
						"altitude": { name: "海拔高度", must: true, table: 0, ruleType: 'number' },
						"ondutytel": { name: "值班电话", must: true },
						"securityofficer": { name: "安全负责人", must: true, table: 0 },
						"securityofficertel": { name: "安全负责人电话", must: true },
						"designheight": { name: "设计总坝高(m)", table: 0, must: true },
						"stackheight": { name: "现状总坝高(m)", table: 0, must: true },
						"defaults": { name: "默认水库大坝", type: 'select' },
						"unifcreditcode": { name: "企业统一信用码", table: 0, placeholder: '(gb 32100-2015)' },
						"unitname": { name: "管理单位", table: 0 },
						"unitadress": { name: "企业所在地", table: 0 },
						"industrycharacterno": { name: "所属企业类型", type: 'select', table: 0 },
						"unitperson": { name: "法人代表", table: 0 },
						"unitpersontel": { name: "法人电话", table: 0 },
						"usedate": { name: "投入使用日期", type: "date", table: 0 },
						"useyear": { name: "设计服务年限", table: 0 },
						"operatingstatus": { name: "运行状况", type: 'select', table: 0 },
						"safetytypeno": { name: "安全度", type: 'select', table: 0 },
						"industrytypeno": { name: "所属行业代码", type: 'select', table: 0 },
						"mineralspecies": { name: "所属矿种", type: 'select', table: 0 },
						"top": { name: "是否头顶库", type: 'select', table: 0 },
						"onlinemonitoringsys": { name: "是否安装在线监测系统", type: 'select', table: 0 },
						"geologicalstructure": { name: "地质构造及条件", table: 0 },
						"topotraphicgradient": { name: "地形坡度(度)", table: 0 },
						"underlyingsurfacetype": { name: "下垫面类型", table: 0 },
						"standardizationlevel": { name: "标准化等级代码", type: 'select', table: 0 },
						"standardforensicsdate": { name: "标准化等级证书取证日期", table: 0, type: "date" },
						"safetypermitno": { name: "安全生产许可证", table: 0 },
						"safetypermitdate": { name: "安全生产许可证有效期", type: "date", table: 0 },
						"safetypermitunit": { name: "安全生产许可证发证机关", table: 0 },
						"storetypeno": { name: "水库大坝类型", type: 'select', table: 0 },
						"designlevel": { name: "设计等级", type: 'select', table: 0 },
						"grade": { name: "现状等级", type: 'select', table: 0 },
						"plancapability": { name: "设计库容(万立方米)", table: 0 },
						"nowvolume": { name: "现状库容(万立方米)", table: 0 },
						"damstocktypeno": { name: "筑坝方式代码", type: 'select', table: 0 },
						"floodequipment": { name: "排洪设施型式", table: 0 },
						"floodmethod": { name: "库外排洪型式", table: 0 },
						"floodfacilitydischarge": { name: "排洪设施泄流量(立方米/秒)", table: 0 },
						"waterarea": { name: "汇水面积(平方公里)", table: 0 },
						"area": { name: "水库大坝面积(平方公里)", table: 0 },
						"floodcontrolstandard": { name: "设计防洪标准(年)", table: 0 },
						"damtype": { name: "初期坝类型", type: 'select', table: 0 },
						"initialdamtype": { name: "初期坝坝型", type: 'select', table: 0 },
						"designinitialdamheight": { name: "设计初期坝高(m)", table: 0 },
						"currentinitialdamheight": { name: "现状初期坝高(m)", table: 0 },
						"initialdamlongness": { name: "初期坝长(m)", table: 0 },
						"initialdamsloperatio": { name: "初期坝坡比", table: 0, placeholder: '例如：1：2' },
						"accumulationdamratio": { name: "堆积坝外坡比", table: 0, placeholder: '例如：1：2' },
						"designsubdamheight": { name: "设计子坝高度", table: 0, placeholder: '单位：m' },
						"designsubdamtopwidth": { name: "设计子坝坝顶宽度", table: 0, placeholder: '单位：m' },
						"accumulateddamsnumber": { name: "已堆积子坝数", table: 0 },
						"earthquake": { name: "设防地震烈度", table: 0, placeholder: '单位：度' },
						"tailingsstoragemethod": { name: "尾矿堆存方式", type: 'select', table: 0 },
						"minelaytypeno": { name: "湿式放矿位置", type: 'select', table: 0 },
						"upstreamtailings": { name: "上游式尾矿堆筑方法", type: 'select', table: 0 },
						"drystorage": { name: "干式堆存方式", type: 'select', table: 0 },
						"drystoragewaterratio": { name: "干式堆存入库尾矿含水率", table: 0, placeholder: '单位：%' },
						"tailingsparticlesize": { name: "尾矿粒度", table: 0, placeholder: '单位：%（-200目占比）' },
						"tailingsaveparticlesize": { name: "尾矿平均粒度", table: 0, placeholder: '单位：mm' },
						"depositiondrybeachslope": { name: "沉积干滩平均坡度", table: 0, placeholder: '单位：%' },
						"personnum": { name: "下游1公里内总人数", table: 0, placeholder: '单位：人' },
						"buildingnum": { name: "下游1公里内建筑物数量", table: 0, placeholder: '单位：栋' },
						"emergencyplanfiled": { name: "应急预案是否备案", type: 'select', table: 0 },
						"primarysafetyunit": { name: "安全预评价单位", table: 0 },
						"primarysafetylevel": { name: "安全预评价单位资质", table: 0 },
						"designunit": { name: "安全设施设计单位", table: 0 },
						"designunitlevel": { name: "安全设施设计单位资质", table: 0 },
						"constructionunit": { name: "施工单位名称", table: 0 },
						"constructionlevel": { name: "施工单位资质等级", table: 0 },
						"supervisoryunit": { name: "工程监理单位名称", table: 0 },
						"supervisorylevel": { name: "工程监理单位资质等级", table: 0 },
						"safetycheckunit": { name: "安全验收评价单位", table: 0 },
						"safetychecklevel": { name: "安全验收评价单位资质", table: 0 },

						"safetyacceptancetime": { name: "安全设施竣工验收时间", type: "date", table: 0 },
						"safetyevaluationunit": { name: "安全现状评价单位", table: 0 },
						"safetyevaluationlevel": { name: "安全现状评价单位资质等级", table: 0 },
						"filingperson": { name: "填写企业（填写人）", table: 0 },
						"filingdate": { name: "填报日期", type: "date", table: 0 },
						"fillerphone": { name: "填表人电话", table: 0 },
						"note": { name: "备注", table: 0 },
						"in_use": { name: "在用状态", type: 'select', table: 0 },
						"is_sync": { name: "同步状态", type: 'select', table: 0 },
						"subtailingno": { name: "关联地区编码", table: 0, form: 0 },
						"createtime": {
							name: "创建时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
						"updatetime": {
							name: "更新时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
					},
					selectList: {
						province: function (a, b) {
							return this.getRegion();
						},
						city: [],
						cityarea: [],
						defaults: [{ name: '是', value: 1, }, { name: '否', value: 0, },],
						top: [{ name: '是', value: 1, }, { name: '否', value: 0, },],
						emergencyplanfiled: [{ name: '是', value: 1, }, { name: '否', value: 0, },],
						onlinemonitoringsys: [{ name: '是', value: 1, }, { name: '否', value: 0, },],
						in_use: [{ name: '是', value: 1, }, { name: '否', value: 0, },],
						is_sync: [{ name: '未同步', value: 0, }, { name: '已同步', value: 1, },],
						damstocktypeno: function () {
							var slist = this.selectList;
							return reqPublic('dic', 'get', {}).then(function (res) {
								var body = res.body || {};
								for (var key in body) {
									var val = body[key];
									slist[key] = val
								}; return body.damstocktypeno;
							});
						},
						risk_entrance: [{ name: '隐藏', value: 0, }, { name: '显示', value: 1, },],
					},
					getRegion: function (val) {
						return reqPublic('dic/areacode/province', 'get', { parentcode: val }).then(function (res) {
							var list = (res.body || {}).list || [];
							return list
						});
					},
					// 编号
					codeSplitJoint: function (fitem) {
						fitem.subtailingno = fitem.province + '_' + fitem.city + '_' + fitem.cityarea;
					},
					addFormItem: function () {
						var Dict = this.Dict, slist = Dict.selectList, info = Dict.baseInfo;
						slist.city = [];
						slist.cityarea = [];
						info.province.disabled = false;
						info.city.disabled = false;
						info.cityarea.disabled = false;
					},
					editFormItem: function () {
						// clearValidate
						this.$refs['cuForm'].$refs['form1'] && this.$refs['cuForm'].$refs['form1'].clearValidate();

						var Dict = this.Dict, slist = Dict.selectList, info = Dict.baseInfo, fitem = this.form.item;
						var codes = fitem.subtailingno.split('_');
						info.province.disabled = true;
						info.city.disabled = true;
						info.cityarea.disabled = true;
						fitem.province = codes[0];
						fitem.city = codes[1];
						fitem.cityarea = codes[2];
						var limit = [{ name: 'city', value: codes[0] }, { name: 'cityarea', value: codes[1] }];
						Tools.asyncLoop.call(this, limit, function (key, panel, next) {
							Dict.getRegion(panel.value).then((res) => {
								slist[panel.name] = res;
								//fitem[panel.name] = codes[~~key+1];
								next();
							});
						});
					},
				},
				config: {
					formWidth: '840px',
					labelWidth: '120',
					operWidth: '180',
					title: '水库大坝',
					buttons: [	// tableBtn
						//{'fn':'', 'type':'success', 'icon':'el-icon-more'},
						{
							'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);
								var cmap = this.Dict.cmap;
								if (cmap) {
									if (item.longitude && item.latitude) {
										cmap.setCenter([item.longitude, item.latitude]);
										cmap.marker && cmap.removeMarker();
										// 添加标记
										cmap.addMarker({
											lnglat: [item.longitude, item.latitude],
											title: '',
											draggable: true,
											dragend: function (e) {
												var lnglat = e.lnglat;
												cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
													item.address = addr;
													item.longitude = lnglat.lng;
													item.latitude = lnglat.lat;
												});
											},
										});
									};
								};
							}
						},
						{
							'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								//reqApi.common.toDelete.call(this.$parent, item);
								/* this.$confirm('为避免误操作，请联系运维人员！', '提示', {
									confirmButtonText: '确定',
									cancelButtonText: '',
									type: 'warning'
								}); */
								this.$alert('为避免误操作，请联系运维人员！', {
									confirmButtonText: '确定',
									callback: action => { }
								});
							}
						}
					],
					otherBtn: [
						{
							'type': 'primary', 'icon': 'el-icon-plus', 'name': '添加水库大坝', 'callback': function () {
								reqApi.common.toAdd.call(this);

								// 地图
								var cmap = this.Dict.cmap;
								cmap && cmap.removeMarker()
							}, permission: ['admin']
						},
					],
					search: [
						{
							'type': 'string', 'name': '水库大坝名称', 'word': 'tailingname', 'mode': 0, 'width': '200px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('tab/tailpondinfor', type, param)
				},
			},
			deviceManage: {			// 设备管理
				Dict: {
					baseInfo: {
						"equipname": { name: "设备名称", must: true },
						"devicetype": { name: "设备类型", type: 'select', must: true, table: 0, },
						"equipno": { name: "设备编号", must: true },
						"eqdanwei": { name: "数值单位", must: true },
						"installationdata": { name: "安装日期", type: "date", must: true },
						"manufacture": { name: "生产厂家", must: true },
						"installationlocate": {
							name: "安装位置", /* must:true,  */disabled: true, type: 'map', style: "display:flex",
							mapConfig: {
								options: {
									zoom: 6,
									center: [107.260044, 36.737982],
									//showLabel: true,
									//pitch: 40,
									onload: function (cmap) {
										var item = this.form.item, self = this;
										this.Dict.cmap = cmap;
										if (item.longitude && item.latitude) {
											cmap.setCenter([item.longitude, item.latitude]);

											// 添加标记
											cmap.addMarker({
												lnglat: [item.longitude, item.latitude],
												title: '',
												draggable: true,
												dragend: function (e) {
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.installationlocate = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
														self.$forceUpdate();
													});
												},
											});
										};
									},
									click: function (e, cmap) {
										var that = this, lnglat = e.lnglat, form = this.form, item = form.item;

										// 如果为添加
										if (!cmap.marker) {
											// 设置地址
											cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
												item.installationlocate = addr;
												item.longitude = lnglat.lng;
												item.latitude = lnglat.lat;
											});

											//cmap.marker && cmap.removeMarker();

											// 添加标记
											cmap.addMarker({
												lnglat: [lnglat.lng, lnglat.lat],
												title: '',
												draggable: true,
												dragend: function (e) {
													var lnglat = e.lnglat;
													cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
														item.installationlocate = addr;
														item.longitude = lnglat.lng;
														item.latitude = lnglat.lat;
													});
												},
											});
										};
									},
								},
							},
						},
						//"tailingid":{name:"所属水库大坝", type:'select', must:true, table:0},
						"longitude": { name: "经度", table: 0, form: 0 },
						"latitude": { name: "纬度", table: 0, form: 0 },
						"installheight": { name: "安装高度", table: 0 },
						"cartesianX": { name: "大地坐标X", table: 0 },
						"cartesianY": { name: "大地坐标Y", table: 0 },
						"cartesianZ": { name: "大地坐标Z", table: 0 },
						"electricitysupply": { name: "供电和通讯方式", table: 0 },
						"accuracy": { name: "设备精度", table: 0 },
						"altitude": { name: "海拔高度(m)", table: 0 },
						"onelevelalarm": { name: "一级预警阈值", table: 0 },
						"twolevelalarm": { name: "二级预警阈值", table: 0 },
						"threelevelalarm": { name: "三级预警阈值", table: 0 },
						"fourlevelalarm": { name: "四级预警阈值", table: 0 },
						"is_used": { name: "设备在用状态", type: 'select', table: 0 },
						"is_sync": { name: "同步状态", type: 'select', table: 0 },
						//"initialstateno":{name:"设备码", table:0},
						"ipaddress": { name: "设备ip地址", table: 0 },
						"eqtype": { name: "设备类型", type: 'select', table: 0 },
						"initial": { name: "传感器初始值", table: 0 },
						"initialx": { name: "初始值x方向", table: 0 },
						"initialy": { name: "初始值y方向", table: 0 },
						"initialz": { name: "初始值z方向", table: 0 },
						"state": { name: "报警状态", type: 'select', table: 0 },
						"burial_depth": { name: "浸润线埋深(m)", table: 0 },
						"checkperiod": { name: "检验周期", table: 0, placeholder: '单位（天）' },
						"jcdid": { name: "所属监测点", type: 'select', table: 0, form: 0, },
						"ksweqtype": { name: "库水位设备类型", type: 'select', table: 0 },
						/* "bmwy_x": { name: "X位移", table: 0 },
						"bmwy_y": { name: "Y位移", table: 0 },
						"bmwy_z": { name: "Z位移", table: 0 }, */
						//"jrxburial_depth":{name:"浸润线埋深(m)", table:0},
						"jrx_trepanning": { name: "孔深(浸润线)", table: 0 },
						"jrx_burial": { name: "设备深度(浸润线)", table: 0 },
						"jrx_coord_x": { name: "距剖面起始点距离(浸润线)", table: 0 },
						"kswequipno": { name: "库水位设备编号", table: 0, placeholder: '添加干滩设备时使用' },
						"gtwangle": { name: "干滩坡度角", table: 0 },
						"gtsafeheight": { name: "干滩安全超高", table: 0 },
						"pslspeed": { name: "排水量流速", table: 0, placeholder: '流速（m/s）' },
						"createtime": {
							name: "创建时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
						"updatetime": {
							name: "更新时间", form: 0, type: "tableFormat", tableFormat: function (val) {
								return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss')
							}
						},
					},
					selectList: {
						is_used: [{ name: '是', value: 1, }, { name: '否', value: 0, },],
						is_sync: [{ name: '已同步', value: 1, }, { name: '未同步', value: 0, },],
						eqtype: [{ name: '4G设备', value: 0, }, { name: 'IP设备', value: 1, },],
						state: [{ name: '是', value: 1, }, { name: '否', value: 0, },],
						ksweqtype: [{ name: '超声', value: 1, }, { name: '投入式', value: 2, },],
						devicetype: function () {
							var slist = this.selectList;
							return reqPublic('dic/drybeachequipinfor', 'get', {}).then(function (res) {
								var body = res.body || {};
								for (var key in body) {
									var val = body[key];
									slist[key] = val
								}; return body.devicetype;
							});
						},
						isonline: [{ name: '在线', value: 1, }, { name: '离线', value: 0, },],
					},
				},
				config: {
					formWidth: '840px',
					labelWidth: '120',
					operWidth: '180',
					title: '设备',
					buttons: [
						//{'fn':'', 'type':'success', 'icon':'el-icon-more'},
						{
							'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit', 'callback': function (item) {
								item = Object.assign({}, item);
								reqApi.common.toEdit.call(this.$parent, item);

								/*
								var Dict = this.Dict, slist = Dict.selectList, info = Dict.baseInfo, fitem = this.form.item;
								var codes = fitem.subtailingno.split('_');
								info.province.disabled = true;
								info.city.disabled = true;
								*/

								var Dict = this.Dict, info = Dict.baseInfo;
								info.equipno.disabled = true;

								var cmap = this.Dict.cmap;
								if (cmap) {
									cmap.marker && cmap.removeMarker();
									if (item.longitude && item.latitude) {
										cmap.setCenter([item.longitude, item.latitude]);
										// 添加标记
										cmap.addMarker({
											lnglat: [item.longitude, item.latitude],
											title: '',
											draggable: true,
											dragend: function (e) {
												var lnglat = e.lnglat;
												cmap.deGeocode([lnglat.lng, lnglat.lat], function (addr) {
													item.installationlocate = addr;
													item.longitude = lnglat.lng;
													item.latitude = lnglat.lat;
												});
											},
										});
									};
								};
							}
						},
						{
							'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete', 'callback': function (item) {
								//var text = '设备删除后，该设备对应的历史数据将被清空，您确认删除该设备吗?';
								reqApi.common.toDelete.call(this.$parent, item/* , {text:text} */);
							}
						}
					],
					otherBtn: [
						{
							fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加设备', 'callback': function () {
								reqApi.common.toAdd.call(this);
								var Dict = this.Dict, info = Dict.baseInfo;
								info.equipno.disabled = false;

								// 地图
								var cmap = this.Dict.cmap;
								cmap && cmap.removeMarker()
							}
						}
					],
					search: [
						{
							'type': 'string', 'name': '设备名称', 'word': 'equipname', 'mode': 0, 'width': '200px', 'clear': function () {
								this.loadData()
							}
						},

						{ 'type': 'select', 'name': '在线状态', 'word': 'isonline', 'mode': 1, 'width': '160px' },
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					return reqPublic('tab/drybeachequipinfor', type, param)
				},
			},
			monitorItems: {		//	监测项管理
				name: '监测项管理',
				Dict: {
					baseInfo: {
						"title": { name: "监测名称", must: true, disabled: true },
						"deviceid": {
							name: "设备名称", must: true, type: 'select', val: 'value', change: function (val, sitem) {
								var Dict = this.Dict, slist = Dict.selectList;
								var info = Dict.baseInfo, fitem = this.form.item, tagInfo = info['deviceid'];

								tagInfo.partName = sitem.name;
								info.subitem.form = 0;
								info.ranges.form = 0;
								info.values.form = 0;
								info.ranges.partName = '';
								info.subitem.partName = '';
								info.values.partName = '';

								reqPublic('/sys/type/sensorid', 'get', { sensorid: val }).then((res) => {
									var body = res.body, subitem = body.subitem, ranges = body.ranges, values = body.values;
									fitem.type = body.type;
									fitem.requrl = body.requrl;
									// hide video
									info.v_appkey.form && this.Dict.setVideoFormStatus(0);
									// hide city
									info['city_weather'].form = 0;

									if (body.type === 't_13') {	// 视频监控 monitor
										info['city_weather'].form = 1;
										fitem.title = sitem.name;
									} else if (body.type === 't_14') {	// 视频监控 monitor
										this.Dict.setVideoFormStatus(1);
										fitem.title = sitem.name;
									} else {
										slist.subitem = subitem;
										slist.ranges = ranges;
										slist.values = values;

										// show
										info.subitem.form = ~~(!!subitem[0]);
										info.ranges.form = ~~(!!ranges[0]);
										info.values.form = ~~(!!values[0]);

										// 赋值
										for (var ikey in info) {
											var obj = info[ikey];
											if (obj.type === 'checkbox' || obj.type === 'radio') {
												var list = slist[ikey];
												if (obj.type === 'checkbox') {
													if (list[0]) {
														fitem[ikey] = [list[0][obj.val]];
														//info[ikey].partName = [list[0][obj.key]]
														info[ikey].partName = [list[0][obj.val]]
													} else {
														fitem[ikey] = [];
														info[ikey].partName = []
													};
												} else {
													if (list[0]) {
														fitem[ikey] = list[0][obj.val]
														info[ikey].partName = list[0][obj.key]
													}
												};
											};
										};
										fitem.title = Dict.nameSplitJoint();
									};
								})
							}
						},
						"subitem": {
							name: "监测类型", type: 'radio', form: 0, style: "display:block", key: 'name', val: 'value', change: function (val, item) {
								var Dict = this.Dict, info = Dict.baseInfo, iitem = info["subitem"], fitem = this.form.item;
								iitem.partName = item.name;
								fitem.title = Dict.nameSplitJoint();
							}
						},
						"ranges": {
							name: "监测范围", type: 'radio', form: 0, style: "display:block", key: 'name', val: 'key', change: function (val, item) {
								var Dict = this.Dict, info = Dict.baseInfo, iitem = info["ranges"], fitem = this.form.item;
								iitem.partName = item.name;
								fitem.title = Dict.nameSplitJoint();
							}
						},
						"values": {
							name: "监测值", must: true, type: 'checkbox', dataType: [], key: 'unit', val: 'value', form: 0, change: function (val, item) {
								var Dict = this.Dict, info = Dict.baseInfo, iitem = info["values"], fitem = this.form.item;
								iitem.partName = val;
								fitem.title = Dict.nameSplitJoint();
							}
						},
						"updatetime": { name: "更新时间", must: true, form: 0, type: "tableFormat", tableFormat: function (val) { return Tools.Dates.format.call(new Date(val), 'yyyy-MM-dd HH:mm:ss') } },
						"titlePart": { form: 0, table: 0, dataType: {} },
						"v_name": {
							name: '视频名称', must: true, form: 0, table: 0, input: function (val) {
								var Dict = this.Dict, info = Dict.baseInfo, fitem = this.form.item;
								fitem.title = info.deviceid.partName + '(' + val + ')';
							},
						},
						"v_id": { name: '视频ID', must: true, form: 0, table: 0 },
						"v_appkey": { name: 'appkey', must: true, form: 0, table: 0 },
						"v_appsecret": { name: 'appsecret', must: true, form: 0, table: 0 },
						"v_channel": { name: '通道名称', must: true, form: 0, table: 0 },
						"v_captcha": { name: '验证码', form: 0, table: 0 },
						"city_weather": { name: '城市全拼', must: true, form: 0, table: 0 },
					},
					selectList: {
						deviceid: function () {
							return reqPublic('tab/drybeachequipinfor/ids', 'get', {}).then(function (res) {
								return res
							});
						},
						subitem: [],
						ranges: [	// 关联日期范围表
						],
						tvalues: [
						],
					},
					// 拼接名称
					nameSplitJoint: function () {
						var info = this.baseInfo;
						var values = info.values.partName ? info.values.partName.join(',') : '';
						var rangesName = info.ranges.partName ? '(' + info.ranges.partName + ')' : '';
						var subitemName = info.subitem.partName || '';
						return info.deviceid.partName + " " + values + subitemName + rangesName;
					},
					addFormItem: function () {
						var Dict = this.Dict, info = Dict.baseInfo;
						info.deviceid.disabled = false;

						info.subitem.form = 0;
						info.subitem.partName = '';
						info.ranges.form = 0;
						info.ranges.partName = '';
						info.values.form = 0;
						info.values.partName = '';

						// 视频监控
						info.v_name.form && this.Dict.setVideoFormStatus(0);

						// 城市天气
						info['city_weather'].form = 0;

						// 刷新监测类型列表
						Dict.getMonitorItem().then(function (res) {
							Dict.selectList.deviceid = res;
						});
					},
					editFormItem: function (item) {
						var Dict = this.Dict, slist = Dict.selectList, info = Dict.baseInfo, fitem = this.form.item;
						item.values = item.values.split(',');

						// hide
						info.deviceid.disabled = true;
						info.subitem.form = 0;
						info.ranges.form = 0;
						info.values.form = 0;
						// 视频监控
						info.v_name.form = 0;
						info.v_id.form = 0;
						info.v_appkey.form = 0;
						info.v_appsecret.form = 0;
						info.v_channel.form = 0;
						info.v_captcha.form = 0;
						// city
						info['city_weather'].form = 0;

						// req
						reqPublic('/sys/type/sensorid', 'get', { sensorid: item.deviceid, id: item.id }).then((res) => {
							var body = res.body, subitem = body.subitem, ranges = body.ranges, values = body.values;
							info.deviceid.partName = body.name;
							if (body.type === 't_13') {	// 视频监控 monitor
								info['city_weather'].form = 1;
								// bind
								this.$set(item, 'city_weather', body.city_weather);
							} else if (body.type === 't_14') {	// 视频监控
								var monitor = body.monitor;
								for (var sKey in monitor) {
									var value = monitor[sKey];
									//fitem[sKey] = value;
									this.$set(item, sKey, value);
									info[sKey].form = 1;
								};
							} else {
								slist.subitem = subitem;
								slist.ranges = ranges;
								slist.values = values;

								// show
								info.subitem.form = ~~(!!subitem[0]);
								info.ranges.form = ~~(!!ranges[0]);
								info.values.form = ~~(!!values[0]);
							};
						})
					},
					setVideoFormStatus: function (status) {
						var info = this.baseInfo;
						var monitor = {
							"v_appkey": "",
							"v_appsecret": "",
							"v_captcha": "",
							"v_channel": "",
							"v_id": "",
							"v_name": ""
						};
						for (var key in monitor) {
							info[key].form = status;
						};
					},
					getMonitorItem: function () {
						return reqPublic('tab/drybeachequipinfor/ids', 'get', {})
					},
				},
				config: {
					formWidth: '520px',
					labelWidth: '120',
					operWidth: '180',
					title: '监测项',
					buttons: [
						{ 'fn': 'toEdit', 'type': 'primary', 'icon': 'el-icon-edit' },
						{ 'fn': 'toDelete', 'type': 'danger', 'icon': 'el-icon-delete' }
					],
					otherBtn: [
						{ fn: 'toAdd', type: 'primary', icon: 'el-icon-plus', name: '添加监测项' }
					],
					search: [
						{
							'type': 'string', 'name': '监测名称', 'word': 'title', 'mode': 0, 'width': '200px', 'clear': function () {
								this.loadData()
							}
						},
						{
							'type': 'button', 'label': '搜索', 'width': '140px', 'icon': 'el-icon-search', 'click': function (e) {
								this.table.page = 1;
								this.loadData()
							}
						},
					],
				},
				request: function (type, param) {
					if (type === 'post' || type === 'put') {
						param.values = param.values.join(',');
					};
					return reqPublic('sys/summary', type, param)
				},
			},
			moduleConfig: {		// 模块数据配制
				name: '模块数据配制',
				getMonitorList: function (param) {
					return reqPublic('sys/summary/code', 'get', param).then(function (res) {
						return res
					});
				},
				getAreaModule: function (param) {
					return reqApi.common.requstEdge('get', 'sys/Area', param);
				},
				getSelectItem: function (type, param) {
					return reqApi.common.requstEdge(type, 'sys/Select', param);
				},
				reqScreenTitle: function (type, param) {
					return reqApi.common.requstEdge(type, 'sys/Area/title', param);
				},
			},
			monitorPointConfig: {	// 监测点
				name: '监测点管理',
				getMonitorPoints: function (param) {	// 查询
					return reqPublic('web/monitorchart', 'get', param).then(function (res) {
						return res
					});
				},
				postBackground: function (param) {
					return reqApi.common.requstEdge('post', 'web/monitorchart', param);
				},
				submitInfos: function (param) {
					return reqApi.common.requstEdge('post', 'web/monitorpoints', param);
				},
				deletePoints: function (param) {
					return reqApi.common.requstEdge('delete', 'web/monitorpoints', param);
				},
			},
			dbaseManage: {	// 数据库备份
				name: '数据库备份',
				backupDatabase: function (param) {
					return reqApi.common.requstEdge('post', 'tab/back', param);
				},
			},
		},
	};
};

// 配制信息
var Config = function () {
	// 获取单元信息
	var getModuleInfo = function (that) {
		var path = that.$route.path || '';
		var parts = path.replace('/', '').split('/');
		var i = 0;
		// 递归遍历
		return (function loop(json) {
			var key = parts[i]; i++;
			return json[key] ? loop(json[key]) : json;
		})(reqApi);
	};
	return { getModuleInfo: getModuleInfo }
};


//export var tailingPond = tailingPond();
export var reqApi = reqApis();
export var Config = Config();

// WEBPACK FOOTER //
// ./src/common/js/common.js
