/**
 * @author: zhaojunbao
 * @date: 2024-11-25 13:45:51
 */
const errorMessages = {
	0: '正常',
	10000: '未初始化蓝牙适配器',
	10001: '当前蓝牙适配器不可用',
	10002: '没有找到指定设备',
	10003: '连接失败',
	10004: '没有找到指定服务',
	10005: '没有找到指定特征值',
	10006: '当前连接已断开',
	10007: '当前特征值不支持此操作',
	10008: '其余所有系统上报的异常',
	10009: 'Android 系统特有，系统版本低于 4.3 不支持 BLE',
	10010: '已连接',
	10011: '配对设备需要配对码',
	10012: '连接超时',
	10013: '连接 deviceId 为空或者是格式不正确',
	2: '信息日志',
};


// 获取当前时间的格式化函数
function getCurrentTime(){
	// 获取当前系统时间
	let now = new Date();
	
	// 格式化时间
	let year = now.getFullYear(); // 获取年份
	let month = (now.getMonth() + 1).toString().padStart(2, '0'); // 获取月份，月份是从0开始的，所以加1后填充前导零（当为一位时）
	let date = now.getDate().toString().padStart(2, '0'); // 获取日期，也进行同样的填充前导零处理
	let hours = now.getHours().toString().padStart(2, '0'); // 获取小时
	let minutes = now.getMinutes().toString().padStart(2, '0'); // 获取分钟
	
	// 拼接年月日时分格式的字符串
	let formattedTime = `${year}-${month}-${date} ${hours}:${minutes}`;
	return formattedTime
}

function logError(errCode, extInfo) {
	console.warn('日志写入', errCode, extInfo)
    // 创建错误日志对象
    const errorLog = {
        time: getCurrentTime(),
        code: errCode,
        message: [extInfo]+':'+(errorMessages[errCode] || ('未知错误'+[errCode]))+';'
    };

    // 获取当前已存储的日志
    let logs = uni.getStorageSync('errorLogs') || [];
	
	

    // 添加新的日志
    logs.push(errorLog);
	
	// 判断数组长度，是否超过 50 条
	if (logs.length > 50) {
		// 移除最老的数据
		logs.shift();
	}

    // 保存更新后的日志
    uni.setStorageSync('errorLogs', logs);
	
	console.warn('日志本地存储', logs.reverse())
}

function displayLogs() {
	const logs = uni.getStorageSync('errorLogs') || []
	let tempLog = []
	logs.forEach((item, index)=>{
		tempLog.push(`[${item.time}][${item.code}]: ${item.message}\n`)
	})
	uni.showModal({
		title: '系统信息',
		content: tempLog.join('') || '没有错误日志',
		icon: 'none',
		 duration: 2000
	});
}

export {
	displayLogs,
	logError,
}
