// #ifndef VUE3
import Vue from 'vue'
import Vuex from 'vuex'
Vue.use(Vuex)
const store = new Vuex.Store({
// #endif

// #ifdef VUE3
import { createStore } from 'vuex'
const store = createStore({
// #endif
	state: {
		// hasLogin: false,
		// isUniverifyLogin: false,
		// loginProvider: "",
		// openid: null,
		// testvuex: false,
		// colorIndex: 0,
		// colorList: ['#FF0000', '#00FF00', '#0000FF'],
		// noMatchLeftWindow: true,
		// active: 'componentPage',
		// leftWinActive: '/pages/component/view/view',
		// activeOpen: '',
		// menu: [],
		// univerifyErrorMsg: ''
		actualDepth: 0, // 孔深
		actualWaterLevel: 0, // 水深
		actualHeat: 0, // 温度
		power1: 0,
		power2: 0,
		qiuId:'',
		connected: false,
		blueConnectLoading: false,
		version: 'shuishen' // 系统版本 默认水深
	},
	mutations: {
		clearMeasureVal(state, testRes){
			state.actualDepth = ''
			state.actualWaterLevel= ''
			state.actualHeat = ''
		},
		setMeasureVal(state, testRes){
			if(testRes.power1){ // 仪器电量
				state.power1 = testRes.power1
			}
			if(testRes.power2){ // 小球电量
				state.power2 = testRes.power2
			}
			if(testRes.qiuId){ // 小球Id
				state.qiuId = testRes.qiuId
			}
			
			if(testRes.actualDepth){ // 实测孔深
				state.actualDepth = testRes.actualDepth
			}
			if(testRes.actualWaterLevel){ // 实测孔深
				state.actualWaterLevel = testRes.actualWaterLevel
			}
			if(testRes.actualHeat){ // 实测温度
				state.actualHeat = testRes.actualHeat
			}
		},
		setLinked(state, flag){
			state.connected = flag
			if(!flag){ // 断开链接时，清空store的测量值
				// 水深版
				state.actualDepth = ''
				state.actualWaterLevel = ''
				// 温度版
				state.actualHeat = ''
				
				// 电量
				state.power1 = ''
				state.power2 = ''
				state.qiuId = ''
			}
		},
		setBlueConnectLoading(state, flag){
			state.blueConnectLoading = flag
		},
		
		setVersion(state, version) {
			state.version = version;
		},
		// logout(state) {
		// 	state.hasLogin = false
		// 	state.openid = null
		// },
		// setOpenid(state, openid) {
		// 	state.openid = openid
		// },
		// setTestTrue(state) {
		// 	state.testvuex = true
		// },
		// setTestFalse(state) {
		// 	state.testvuex = false
		// },
		// setColorIndex(state, index) {
		// 	state.colorIndex = index
		// },
		// setMatchLeftWindow(state, matchLeftWindow) {
		// 	state.noMatchLeftWindow = !matchLeftWindow
		// },
		// setActive(state, tabPage) {
		// 	state.active = tabPage
		// },
		// setLeftWinActive(state, leftWinActive) {
		// 	state.leftWinActive = leftWinActive
		// },
		// setActiveOpen(state, activeOpen) {
		// 	state.activeOpen = activeOpen
		// },
		// setMenu(state, menu) {
		// 	state.menu = menu
		// },
		// setUniverifyLogin(state, payload) {
		// 	typeof payload !== 'boolean' ? payload = !!payload : '';
		// 	state.isUniverifyLogin = payload;
		// },
		// setUniverifyErrorMsg(state,payload = ''){
		// 	state.univerifyErrorMsg = payload
		// }
	},
	getters: {
		currentColor(state) {
			return state.colorList[state.colorIndex]
		}
	},
	actions: {
		// lazy loading openid
		getUserOpenId: async function({
			commit,
			state
		}) {
			return await new Promise((resolve, reject) => {
				if (state.openid) {
					resolve(state.openid)
				} else {
					uni.login({
						success: (data) => {
							commit('login')
							setTimeout(function() { //模拟异步请求服务器获取 openid
								const openid = '123456789'
								console.log('uni.request mock openid[' + openid + ']');
								commit('setOpenid', openid)
								resolve(openid)
							}, 1000)
						},
						fail: (err) => {
							console.log('uni.login 接口调用失败，将无法正常使用开放接口等服务', err)
							reject(err)
						}
					})
				}
			})
		},
		getPhoneNumber: function({
			commit
		}, univerifyInfo) {
			return new Promise((resolve, reject) => {
				uni.request({
					url: 'https://97fca9f2-41f6-449f-a35e-3f135d4c3875.bspapp.com/http/univerify-login',
					method: 'POST',
					data: univerifyInfo,
					success: (res) => {
						const data = res.data
						if (data.success) {
							resolve(data.phoneNumber)
						} else {
							reject(res)
						}

					},
					fail: (err) => {
						reject(res)
					}
				})
			})
		}
	}
})

export default store
