/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.TcpClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;

public class TcpClient {
    public static String HOST = "127.0.0.1";
    public static int PORT = 9200;
    public static Bootstrap bootstrap = TcpClient.getBootstrap();
    public static Channel channel = TcpClient.getChannel(HOST, PORT);

    public static final Bootstrap getBootstrap() {
        NioEventLoopGroup group = new NioEventLoopGroup();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
        b.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
                pipeline.addLast("decoder", (ChannelHandler)new StringDecoder());
                pipeline.addLast("handler", (ChannelHandler)new TcpClientHandler());
            }
        });
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return b;
    }

    public static final Channel getChannel(String host, int port) {
        Channel channel = null;
        try {
            channel = bootstrap.connect(host, port).sync().channel();
        }
        catch (Exception e) {
            System.out.println("Connect Server(IP{},PORT{}) Failedhost:" + host + "port:" + port + "e:" + e);
            return null;
        }
        return channel;
    }

    public static void sendMsg(String msg) throws Exception {
        if (channel != null) {
            channel.writeAndFlush((Object)msg).sync();
        } else {
            System.out.println("Msg Send Failed , Connection Lost!");
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            TcpClient.sendMsg("02");
        }
        catch (Exception e) {
            System.out.println("main err:" + e);
        }
    }
}

