/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.fazecast.jSerialComm.SerialPort;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerHandler
extends SimpleChannelInboundHandler<Object> {
    private Logger logger = LoggerFactory.getLogger(TcpServerHandler.class);
    private static SerialPort serialPort;

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        System.out.println("\u63a5\u6536\u5230\u7684\u57fa\u7ad9\u6570\u636e:" + msg.toString());
        String writeData = msg.toString();
        byte[] bytes = writeData.getBytes();
        this.writeComm(serialPort, bytes);
        Thread.sleep(20L);
        String result = this.readComm(serialPort);
        System.out.println("COM\u53e3\u8bfb\u51fa\u6570\u636e:" + result);
    }

    public static SerialPort openComm() {
        SerialPort[] serialPorts;
        for (SerialPort port : serialPorts = SerialPort.getCommPorts()) {
            System.out.println("PortName:" + port.getSystemPortName());
            System.out.println("PortDesc:" + port.getPortDescription());
            System.out.println("PortDescriptivePortName:" + port.getDescriptivePortName());
        }
        serialPort = serialPorts[0];
        serialPort.setBaudRate(115200);
        serialPort.setComPortTimeouts(272, 1000, 1000);
        serialPort.setRTS();
        serialPort.setFlowControl(0);
        serialPort.setComPortParameters(115200, 8, 1, 0);
        if (!serialPort.isOpen()) {
            boolean isCommOpeded = serialPort.openPort();
            System.out.println("COM\u53e3\u662f\u5426\u6253\u5f00: " + isCommOpeded);
        }
        return serialPort;
    }

    private void writeComm(SerialPort serialPort, byte[] data) throws InterruptedException {
        if (serialPort == null || !serialPort.isOpen()) {
            System.out.println("COM\u53e3\u672a\u6253\u5f00");
            return;
        }
        serialPort.writeBytes(data, (long)data.length);
        System.out.println("COM\u53e3\u5df2\u5199\u5165\u6570\u636e" + data.toString());
    }

    private String readComm(SerialPort serialPort) {
        if (serialPort == null || !serialPort.isOpen()) {
            System.out.println("COM\u53e3\u672a\u6253\u5f00");
            return null;
        }
        String readData = "";
        while (serialPort.bytesAvailable() > 0) {
            byte[] newData = new byte[serialPort.bytesAvailable()];
            int numRead = serialPort.readBytes(newData, (long)newData.length);
            String newDataString = new String(newData);
            readData = readData + newDataString;
        }
        return readData;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        System.out.println("exceptionCaught! cause:" + cause.toString());
        ctx.close();
    }
}

