/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.fazecast.jSerialComm.SerialPort;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerHandler
extends SimpleChannelInboundHandler<Object> {
    private Logger logger = LoggerFactory.getLogger(TcpServerHandler.class);
    private static SerialPort serialPort;

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        System.out.println("**\u63a5\u6536\u5230\u7684\u57fa\u7ad9\u6570\u636e<<start:" + msg.toString() + ">>end");
        String writeData = msg.toString();
        byte[] bytes = writeData.getBytes();
        this.writeComm(serialPort, bytes);
        Thread.sleep(20L);
        String result = this.readComm(serialPort);
        System.out.println("**COM\u53e3\u8bfb\u51fa\u6570\u636e<<start:" + result + ">>end");
    }

    public static SerialPort openComm() {
        SerialPort[] serialPorts;
        for (SerialPort port : serialPorts = SerialPort.getCommPorts()) {
            System.out.println("PortName:" + port.getSystemPortName());
            System.out.println("PortDesc:" + port.getPortDescription());
            System.out.println("PortDescriptivePortName:" + port.getDescriptivePortName());
            if (!port.getSystemPortName().equalsIgnoreCase("COM1")) continue;
            serialPort = port;
        }
        serialPort.setBaudRate(115200);
        serialPort.setComPortTimeouts(272, 1000, 1000);
        serialPort.setRTS();
        serialPort.setFlowControl(0);
        serialPort.setComPortParameters(115200, 8, 1, 0);
        if (!serialPort.isOpen()) {
            boolean isCommOpeded = serialPort.openPort();
            System.out.println("COM\u53e3\u662f\u5426\u6253\u5f00: " + isCommOpeded);
        }
        return serialPort;
    }

    private void writeComm(SerialPort serialPort, byte[] data) throws InterruptedException {
        if (serialPort == null || !serialPort.isOpen()) {
            System.out.println("COM\u53e3\u672a\u6253\u5f00");
            return;
        }
        int result = serialPort.writeBytes(data, data.length);
        if (result != -1) {
            System.out.println("COM\u53e3\u5df2\u6210\u529f\u5199\u5165\u6570\u636e");
        } else {
            System.out.println("COM\u53e3\u5199\u6570\u636e\u5931\u8d25");
        }
    }

    private String readComm(SerialPort serialPort) {
        if (serialPort == null || !serialPort.isOpen()) {
            System.out.println("COM\u53e3\u672a\u6253\u5f00");
            return null;
        }
        String readData = "";
        while (serialPort.bytesAvailable() > 0) {
            byte[] newData = new byte[serialPort.bytesAvailable()];
            int numRead = serialPort.readBytes(newData, newData.length);
            String newDataString = new String(newData);
            readData = readData + newDataString;
        }
        return readData;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        System.out.println("exceptionCaught! cause:" + cause.toString());
        ctx.close();
    }
}

